/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.sonymobile.tools.gerrit.gerritevents.ssh.Authentication;
import com.sonymobile.tools.gerrit.gerritevents.ssh.AuthenticationUpdater;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnection;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnectionImpl
implements SshConnection {
    private static final Logger logger = LoggerFactory.getLogger(SshConnectionImpl.class);
    private static final int ALIVE_INTERVAL = 30000;
    private static final int CLOSURE_WAIT_TIMEOUT = 200;
    private static final int CLOSURE_WAIT_INTERVAL = 50;
    protected static final String CMD_EXEC = "exec";
    protected static final int PROTO_HOST_DELIM_LENGTH = 3;
    private JSch client;
    private Session connectSession;
    private String host;
    private int port;
    private String proxy;
    private Authentication authentication;
    private AuthenticationUpdater updater;
    private int connectionTimeout;

    protected SshConnectionImpl(String host, int port, Authentication authentication) {
        this(host, port, "", authentication, null, 0);
    }

    protected SshConnectionImpl(String host, int port, String proxy, Authentication authentication) {
        this(host, port, proxy, authentication, null, 0);
    }

    protected SshConnectionImpl(String host, int port, String proxy, Authentication authentication, AuthenticationUpdater updater) {
        this(host, port, proxy, authentication, updater, 0);
    }

    protected SshConnectionImpl(String host, int port, String proxy, Authentication authentication, AuthenticationUpdater updater, int connectionTimeout) {
        this.host = host;
        this.port = port;
        this.proxy = proxy;
        this.authentication = authentication;
        this.updater = updater;
        this.connectionTimeout = connectionTimeout;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void connect() throws IOException {
        Authentication updatedAuth;
        logger.debug("connecting...");
        Authentication auth = this.authentication;
        if (this.updater != null && (updatedAuth = this.updater.updateAuthentication(this.authentication)) != null && auth != updatedAuth) {
            auth = updatedAuth;
        }
        try {
            this.client = new JSch();
            if (auth.getPrivateKeyPhrase() == null) {
                this.client.addIdentity(auth.getPrivateKeyFile().getAbsolutePath(), auth.getPrivateKeyFilePassword());
            } else {
                this.client.addIdentity(auth.getUsername(), auth.getPrivateKeyPhrase(), null, auth.getPrivateKeyFilePassword().getBytes("UTF-8"));
            }
            this.client.setHostKeyRepository((HostKeyRepository)new BlindHostKeyRepository());
            this.connectSession = this.client.getSession(auth.getUsername(), this.host, this.port);
            this.connectSession.setConfig("PreferredAuthentications", "publickey");
            if (this.proxy != null && !this.proxy.isEmpty()) {
                String[] splitted = this.proxy.split(":");
                if (splitted.length <= 2 || splitted[1].length() < 3) throw new MalformedURLException(this.proxy);
                String pproto = splitted[0];
                String phost = splitted[1].substring(2);
                int pport = Integer.parseInt(splitted[2]);
                if (!pproto.equals("socks5") && !pproto.equals("http")) throw new MalformedURLException("Only http and socks5 protocols are supported");
                if (pproto.equals("socks5")) {
                    this.connectSession.setProxy((Proxy)new ProxySOCKS5(phost, pport));
                } else {
                    this.connectSession.setProxy((Proxy)new ProxyHTTP(phost, pport));
                }
            }
            this.connectSession.connect(this.connectionTimeout);
            logger.debug("Connected: {}", (Object)this.connectSession.isConnected());
            this.connectSession.setServerAliveInterval(30000);
            return;
        }
        catch (JSchException ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public synchronized boolean isConnected() {
        return this.isAuthenticated();
    }

    @Override
    public synchronized boolean isAuthenticated() {
        return this.client != null && this.connectSession != null && this.connectSession.isConnected();
    }

    @Override
    public synchronized String executeCommand(String command) throws SshException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected!");
        }
        Channel channel = null;
        try {
            logger.debug("Opening channel");
            channel = this.connectSession.openChannel(CMD_EXEC);
            ((ChannelExec)channel).setCommand(command);
            ByteArrayOutputStream errOut = new ByteArrayOutputStream();
            channel.setExtOutputStream((OutputStream)errOut);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(channel.getInputStream()));
            logger.debug("connecting channel.");
            channel.connect();
            String incomingLine = null;
            StringBuilder commandOutput = new StringBuilder();
            while ((incomingLine = bufferedReader.readLine()) != null) {
                commandOutput.append(incomingLine);
                commandOutput.append('\n');
                logger.trace("Incoming line: {}", (Object)incomingLine);
            }
            logger.trace("Closing reader.");
            bufferedReader.close();
            SshConnectionImpl.waitForChannelClosure(channel, 200L);
            int exitCode = channel.getExitStatus();
            if (exitCode > 0) {
                String error = errOut.toString();
                if (error != null && error.trim().length() > 0) {
                    throw new SshException(error.trim() + " (" + String.valueOf(exitCode) + ")");
                }
                throw new SshException(String.valueOf(exitCode));
            }
            String string = commandOutput.toString();
            return string;
        }
        catch (SshException ex) {
            throw ex;
        }
        catch (JSchException ex) {
            throw new SshException(ex);
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
        finally {
            if (channel != null) {
                logger.trace("disconnecting channel.");
                channel.disconnect();
            }
        }
    }

    private static void waitForChannelClosure(Channel channel, long timoutInMs) {
        long start = System.currentTimeMillis();
        long until = start + timoutInMs;
        try {
            while (!channel.isClosed() && System.currentTimeMillis() < until) {
                Thread.sleep(50L);
            }
            logger.trace("Time waited for channel closure: " + (System.currentTimeMillis() - start));
        }
        catch (InterruptedException e) {
            logger.trace("Interrupted", (Throwable)e);
        }
        if (!channel.isClosed()) {
            logger.trace("Channel not closed in timely manner!");
        }
    }

    @Override
    public synchronized Reader executeCommandReader(String command) throws SshException, IOException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected!");
        }
        try {
            Channel channel = this.connectSession.openChannel(CMD_EXEC);
            ((ChannelExec)channel).setCommand(command);
            InputStreamReader reader = new InputStreamReader(channel.getInputStream(), "utf-8");
            channel.connect();
            return reader;
        }
        catch (JSchException ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public ChannelExec executeCommandChannel(String command) throws SshException, IOException {
        return this.executeCommandChannel(command, true);
    }

    @Override
    public synchronized ChannelExec executeCommandChannel(String command, Boolean establishConnection) throws SshException, IOException {
        if (!this.isConnected()) {
            throw new IOException("Not connected!");
        }
        try {
            ChannelExec channel = (ChannelExec)this.connectSession.openChannel(CMD_EXEC);
            channel.setCommand(command);
            if (establishConnection.booleanValue()) {
                channel.connect();
            }
            return channel;
        }
        catch (JSchException ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public synchronized void disconnect() {
        if (this.connectSession != null) {
            logger.debug("Disconnecting client connection.");
            this.connectSession.disconnect();
            this.connectSession = null;
        }
    }

    static class BlindHostKeyRepository
    implements HostKeyRepository {
        private static final HostKey[] EMPTY = new HostKey[0];

        BlindHostKeyRepository() {
        }

        public int check(String host, byte[] key) {
            return 0;
        }

        public void add(HostKey hostkey, UserInfo ui) {
        }

        public void remove(String host, String type) {
        }

        public void remove(String host, String type, byte[] key) {
        }

        public String getKnownHostsRepositoryID() {
            return "";
        }

        public HostKey[] getHostKey() {
            return EMPTY;
        }

        public HostKey[] getHostKey(String host, String type) {
            return EMPTY;
        }
    }
}

