/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.ssh;

import com.sonymobile.tools.gerrit.gerritevents.ssh.Authentication;
import com.sonymobile.tools.gerrit.gerritevents.ssh.AuthenticationUpdater;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnection;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnectionImpl;
import java.io.IOException;

public abstract class SshConnectionFactory {
    private SshConnectionFactory() {
        throw new UnsupportedOperationException("Cannot instantiate util classes.");
    }

    public static SshConnection getConnection(String host, int port, Authentication authentication) throws IOException {
        return SshConnectionFactory.getConnection(host, port, "", authentication);
    }

    public static SshConnection getConnection(String host, int port, String proxy, Authentication authentication) throws IOException {
        return SshConnectionFactory.getConnection(host, port, proxy, authentication, null, 0);
    }

    public static SshConnection getConnection(String host, int port, String proxy, Authentication authentication, int connectionTimeout) throws IOException {
        return SshConnectionFactory.getConnection(host, port, proxy, authentication, null, connectionTimeout);
    }

    public static SshConnection getConnection(String host, int port, String proxy, Authentication authentication, AuthenticationUpdater updater) throws IOException {
        return SshConnectionFactory.getConnection(host, port, proxy, authentication, updater, 0);
    }

    public static SshConnection getConnection(String host, int port, String proxy, Authentication authentication, AuthenticationUpdater updater, int connectionTimeout) throws IOException {
        SshConnectionImpl connection = new SshConnectionImpl(host, port, proxy, authentication, updater, connectionTimeout);
        connection.connect();
        return connection;
    }
}

