/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.helpers;

import com.sonymobile.tools.gerrit.gerritevents.GerritQueryException;
import com.sonymobile.tools.gerrit.gerritevents.GerritQueryHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileHelper {
    private static final Logger logger = LoggerFactory.getLogger(FileHelper.class);

    private FileHelper() {
    }

    public static List<String> getFilesByChange(GerritQueryHandler gerritQueryHandler, String changeId) {
        try {
            List<JSONObject> jsonList = gerritQueryHandler.queryFiles("change:" + changeId);
            for (JSONObject json : jsonList) {
                JSONArray changedFiles;
                int numberOfFiles;
                if (json.has("type") && "stats".equalsIgnoreCase(json.getString("type")) || !json.has("currentPatchSet")) continue;
                JSONObject currentPatchSet = json.getJSONObject("currentPatchSet");
                if (!currentPatchSet.has("files") || (numberOfFiles = (changedFiles = currentPatchSet.optJSONArray("files")).size()) <= 0) break;
                ArrayList<String> files = new ArrayList<String>(numberOfFiles);
                for (int i = 0; i < changedFiles.size(); ++i) {
                    JSONObject file = changedFiles.getJSONObject(i);
                    files.add(file.getString("file"));
                }
                return files;
            }
        }
        catch (IOException e) {
            logger.error("IOException occurred. ", (Throwable)e);
        }
        catch (GerritQueryException e) {
            logger.error("Bad query. ", (Throwable)e);
        }
        return null;
    }
}

