/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.dto.rest;

import com.sonymobile.tools.gerrit.gerritevents.GerritQueryException;
import com.sonymobile.tools.gerrit.gerritevents.GerritQueryHandler;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Change;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.PatchSet;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Topic {
    private static final Logger logger = LoggerFactory.getLogger(ChangeBasedEvent.class);
    private final String name;
    private Map<GerritQueryHandler, Map<Change, PatchSet>> changes = null;

    public Topic(String name) {
        this.name = name;
        this.changes = new HashMap<GerritQueryHandler, Map<Change, PatchSet>>();
    }

    public String getName() {
        return this.name;
    }

    public Map<Change, PatchSet> queryChanges(GerritQueryHandler gerritQueryHandler) {
        if (StringUtils.isEmpty((String)this.name)) {
            logger.error("Topic name can not be empty");
            return Collections.emptyMap();
        }
        HashMap<Change, PatchSet> result = new HashMap<Change, PatchSet>();
        try {
            List<JSONObject> jsonList = gerritQueryHandler.queryCurrentPatchSets("topic:{" + this.name + "}");
            for (JSONObject json : jsonList) {
                if (json.has("type") && "stats".equalsIgnoreCase(json.getString("type")) || !json.has("currentPatchSet")) continue;
                JSONObject currentPatchSet = json.getJSONObject("currentPatchSet");
                result.put(new Change(json), new PatchSet(currentPatchSet));
            }
        }
        catch (IOException e) {
            logger.error("IOException occured. ", (Throwable)e);
        }
        catch (GerritQueryException e) {
            logger.error("Bad query. ", (Throwable)e);
        }
        return result;
    }

    public Map<Change, PatchSet> getChanges(GerritQueryHandler gerritQueryHandler) {
        if (this.changes.containsKey(gerritQueryHandler)) {
            return this.changes.get(gerritQueryHandler);
        }
        Map<Change, PatchSet> result = this.queryChanges(gerritQueryHandler);
        this.changes.put(gerritQueryHandler, result);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Topic topic = (Topic)o;
        return this.name != null ? this.name.equals(topic.name) : topic.name == null;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return this.name;
    }
}

