/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.dto.rest;

import com.sonymobile.tools.gerrit.gerritevents.dto.rest.CommentedFile;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.LineComment;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.Notify;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.ReviewLabel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReviewInput {
    final String message;
    final Map<String, Integer> labels = new HashMap<String, Integer>();
    final Map<String, Set<LineComment>> comments = new HashMap<String, Set<LineComment>>();
    Notify notify;
    String tag;

    public ReviewInput(String message, String labelName, int labelValue) {
        this(message, Collections.singleton(new ReviewLabel(labelName, labelValue)));
    }

    public ReviewInput(String message, ReviewLabel ... labels) {
        this(message, Arrays.asList(labels));
    }

    public ReviewInput(String message, Collection<ReviewLabel> labels) {
        this(message, labels, Collections.emptyList());
    }

    public ReviewInput(String message, Collection<CommentedFile> commentedFiles, ReviewLabel ... labels) {
        this(message, Arrays.asList(labels), commentedFiles);
    }

    public ReviewInput(String message, Collection<ReviewLabel> labels, Collection<CommentedFile> commentedFiles) {
        this.message = message;
        for (ReviewLabel label : labels) {
            this.labels.put(label.getName(), label.getValue());
        }
        for (CommentedFile file : commentedFiles) {
            if (!this.comments.containsKey(file.getFileName())) {
                this.comments.put(file.getFileName(), new HashSet());
            }
            this.comments.get(file.getFileName()).addAll(file.getLineComments());
        }
    }

    public ReviewInput setNotify(Notify value) {
        this.notify = value;
        return this;
    }

    public ReviewInput setTag(String value) {
        this.tag = value;
        return this;
    }
}

