/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.dto.rest;

import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Change;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeId {
    private static final Logger logger = LoggerFactory.getLogger(ChangeId.class);
    private final String projectName;
    private final String branchName;
    private final String id;

    public ChangeId(String projectName, String branchName, String id) {
        this.projectName = projectName;
        this.branchName = branchName;
        this.id = id;
    }

    public ChangeId(Change change) {
        this(change.getProject(), change.getBranch(), change.getId());
    }

    public String asUrlPart() {
        try {
            return this.encode(this.projectName) + "~" + this.encode(this.branchName) + "~" + this.id;
        }
        catch (UnsupportedEncodingException e) {
            String parameter = this.projectName + "~" + this.branchName + "~" + this.id;
            logger.error("Failed to encode ChangeId {}, falling back to unencoded {}", (Object)this, (Object)parameter);
            return parameter;
        }
    }

    private String encode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8");
    }

    public String toString() {
        return "ChangeId{projectName='" + this.projectName + '\'' + ", branchName='" + this.branchName + '\'' + ", id='" + this.id + '\'' + '}';
    }
}

