/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.dto.events;

import com.sonymobile.tools.gerrit.gerritevents.GerritJsonEventFactory;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEventType;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Account;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Approval;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class VoteDeleted
extends ChangeBasedEvent {
    private String comment;
    private List<Approval> approvals = new ArrayList<Approval>();
    private Account reviewer;
    private Account remover;

    @Override
    public GerritEventType getEventType() {
        return GerritEventType.VOTE_DELETED;
    }

    public List<Approval> getApprovals() {
        return this.approvals;
    }

    public void setApprovals(List<Approval> approvals) {
        this.approvals = approvals;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setReviewer(Account reviewer) {
        this.reviewer = reviewer;
    }

    public Account getRemover() {
        return this.remover;
    }

    public void setRemover(Account remover) {
        this.remover = remover;
    }

    public Account getReviewer() {
        return this.reviewer;
    }

    @Override
    public boolean isScorable() {
        return true;
    }

    @Override
    public void fromJson(JSONObject json) {
        super.fromJson(json);
        this.comment = GerritJsonEventFactory.getString(json, "comment");
        if (json.containsKey((Object)"reviewer")) {
            this.reviewer = new Account(json.getJSONObject("reviewer"));
        }
        if (json.containsKey((Object)"remover")) {
            this.remover = new Account(json.getJSONObject("remover"));
        }
        if (json.containsKey((Object)"approvals")) {
            JSONArray eventApprovals = json.getJSONArray("approvals");
            for (int i = 0; i < eventApprovals.size(); ++i) {
                this.approvals.add(new Approval(eventApprovals.getJSONObject(i)));
            }
        }
    }
}

