/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.dto.events;

import com.sonymobile.tools.gerrit.gerritevents.GerritJsonEventFactory;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEventType;
import com.sonymobile.tools.gerrit.gerritevents.dto.RepositoryModifiedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import net.sf.json.JSONObject;

public class ProjectCreated
extends GerritTriggeredEvent
implements RepositoryModifiedEvent {
    private String projectName;
    private String headName;

    public String getHeadName() {
        return this.headName;
    }

    public void setHeadName(String headName) {
        this.headName = headName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public void fromJson(JSONObject json) {
        super.fromJson(json);
        this.projectName = GerritJsonEventFactory.getString(json, "projectName");
        this.headName = GerritJsonEventFactory.getString(json, "headName");
    }

    @Override
    public GerritEventType getEventType() {
        return GerritEventType.PROJECT_CREATED;
    }

    @Override
    public boolean isScorable() {
        return false;
    }

    @Override
    public String getModifiedProject() {
        return this.projectName;
    }

    @Override
    public String getModifiedRef() {
        return this.headName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectCreated that = (ProjectCreated)o;
        return this.projectName.equals(that.projectName);
    }

    public int hashCode() {
        return this.projectName.hashCode();
    }
}

