/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.dto.events;

import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEventType;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class HashtagsChanged
extends ChangeBasedEvent {
    private List<String> hashtags;
    private List<String> removedHashtags;
    private List<String> addedHashtags;

    @Override
    public GerritEventType getEventType() {
        return GerritEventType.HASHTAGS_CHANGED;
    }

    @Override
    public boolean isScorable() {
        return false;
    }

    public List<String> getHashtags() {
        return this.hashtags;
    }

    public List<String> getAddedHashtags() {
        return this.addedHashtags;
    }

    public List<String> getRemovedHashtags() {
        return this.removedHashtags;
    }

    @Override
    public void fromJson(JSONObject json) {
        super.fromJson(json);
        this.hashtags = this.hashtagsFromArray(json, "hashtags");
        this.removedHashtags = this.hashtagsFromArray(json, "removed");
        this.addedHashtags = this.hashtagsFromArray(json, "added");
    }

    private List<String> hashtagsFromArray(JSONObject json, String array) {
        if (json.containsKey((Object)array)) {
            JSONArray hashtagsArray = json.getJSONArray(array);
            ArrayList<String> result = new ArrayList<String>(hashtagsArray.size());
            for (Object tag : hashtagsArray) {
                result.add(tag.toString());
            }
            return result;
        }
        return Collections.emptyList();
    }
}

