/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.dto.events;

import com.sonymobile.tools.gerrit.gerritevents.GerritJsonEventFactory;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEventType;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Account;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Approval;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class CommentAdded
extends ChangeBasedEvent {
    private String comment;
    private List<Approval> approvals = new ArrayList<Approval>();

    @Override
    public GerritEventType getEventType() {
        return GerritEventType.COMMENT_ADDED;
    }

    public List<Approval> getApprovals() {
        return this.approvals;
    }

    public void setApprovals(List<Approval> approvals) {
        this.approvals = approvals;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public boolean isScorable() {
        return true;
    }

    @Override
    public void fromJson(JSONObject json) {
        super.fromJson(json);
        this.comment = GerritJsonEventFactory.getString(json, "comment");
        if (json.containsKey((Object)"author")) {
            this.account = new Account(json.getJSONObject("author"));
        }
        if (json.containsKey((Object)"approvals")) {
            JSONArray eventApprovals = json.getJSONArray("approvals");
            for (int i = 0; i < eventApprovals.size(); ++i) {
                this.approvals.add(new Approval(eventApprovals.getJSONObject(i)));
            }
        }
    }

    @Override
    public int hashCode() {
        int a = 0;
        if (this.comment != null) {
            a = this.comment.hashCode();
        }
        return super.hashCode() + a;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        CommentAdded event = (CommentAdded)o;
        if (this.comment == null) {
            return event.comment == null;
        }
        return this.comment.equals(event.comment);
    }
}

