/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.dto.events;

import com.sonymobile.tools.gerrit.gerritevents.GerritJsonEventFactory;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEventType;
import com.sonymobile.tools.gerrit.gerritevents.dto.RepositoryModifiedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Account;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import net.sf.json.JSONObject;

public class ChangeMerged
extends ChangeBasedEvent
implements RepositoryModifiedEvent {
    protected String newRev;

    public ChangeMerged() {
    }

    public ChangeMerged(JSONObject json) {
        this.fromJson(json);
    }

    @Override
    public GerritEventType getEventType() {
        return GerritEventType.CHANGE_MERGED;
    }

    @Override
    public boolean isScorable() {
        return false;
    }

    @Override
    public String getModifiedProject() {
        if (this.change != null) {
            return this.change.getProject();
        }
        return null;
    }

    @Override
    public String getModifiedRef() {
        if (this.patchSet != null) {
            return this.patchSet.getRef();
        }
        return null;
    }

    @Override
    public void fromJson(JSONObject json) {
        super.fromJson(json);
        if (json.containsKey((Object)"submitter")) {
            this.account = new Account(json.getJSONObject("submitter"));
        }
        if (json.containsKey((Object)"newRev")) {
            this.newRev = GerritJsonEventFactory.getString(json, "newRev");
        }
    }

    public String getNewRev() {
        return this.newRev;
    }

    public void setNewRev(String newRev) {
        this.newRev = newRev;
    }
}

