/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.dto.attr;

import com.sonymobile.tools.gerrit.gerritevents.GerritJsonEventFactory;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritJsonDTO;
import net.sf.json.JSONObject;

public class Provider
implements GerritJsonDTO {
    private String name;
    private String host;
    private String port;
    private String scheme;
    private String url;
    private String version;
    @Deprecated
    private transient String proto;

    public Provider() {
    }

    public Provider(JSONObject json) {
        this.fromJson(json);
    }

    public Provider(String name, String host, String port, String scheme, String url, String version) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.scheme = scheme;
        this.url = url;
        this.version = version;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.name = GerritJsonEventFactory.getString(json, "name");
        this.host = GerritJsonEventFactory.getString(json, "host");
        this.port = GerritJsonEventFactory.getString(json, "port");
        this.scheme = GerritJsonEventFactory.getString(json, "proto");
        if (this.scheme == null) {
            this.scheme = GerritJsonEventFactory.getString(json, "scheme");
        }
        this.url = GerritJsonEventFactory.getString(json, "url");
        this.version = GerritJsonEventFactory.getString(json, "version");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getProto() {
        return this.getScheme();
    }

    public void setProto(String proto) {
        this.setScheme(proto);
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getUrl() {
        String frontUrl = this.url;
        if (frontUrl != null && !frontUrl.isEmpty() && !frontUrl.endsWith("/")) {
            frontUrl = frontUrl + '/';
        }
        return frontUrl;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "Provider: " + this.getName() + " " + this.getHost() + " " + this.getPort() + " " + this.getScheme() + " " + this.getUrl() + " " + this.getVersion();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Provider other = (Provider)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        if (this.scheme == null ? other.scheme != null : !this.scheme.equals(other.scheme)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    protected Object readResolve() {
        if (this.proto != null && this.scheme == null) {
            this.scheme = this.proto;
            this.proto = null;
        } else if (this.scheme == null && this.proto == null) {
            this.scheme = "ssh";
        }
        return this;
    }
}

