/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.dto.attr;

import com.sonymobile.tools.gerrit.gerritevents.GerritJsonEventFactory;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritChangeKind;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritJsonDTO;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Account;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Approval;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PatchSet
implements GerritJsonDTO {
    private String number;
    private String revision;
    private String ref;
    private boolean draft;
    private GerritChangeKind kind;
    private Account uploader;
    private Account author;
    private List<Approval> approvals;
    private List<String> parents;
    private Date createdOn;

    public PatchSet() {
    }

    public PatchSet(JSONObject json) {
        this.fromJson(json);
    }

    @Override
    public void fromJson(JSONObject json) {
        int i;
        this.number = GerritJsonEventFactory.getString(json, "number");
        this.revision = GerritJsonEventFactory.getString(json, "revision");
        this.draft = GerritJsonEventFactory.getBoolean(json, "isDraft");
        this.createdOn = GerritJsonEventFactory.getDate(json, "createdOn");
        if (json.containsKey((Object)"kind")) {
            this.kind = GerritChangeKind.fromString(GerritJsonEventFactory.getString(json, "kind"));
        }
        this.ref = GerritJsonEventFactory.getString(json, "ref");
        if (json.containsKey((Object)"uploader")) {
            this.uploader = new Account(json.getJSONObject("uploader"));
        }
        if (json.containsKey((Object)"author")) {
            this.author = new Account(json.getJSONObject("author"));
        }
        if (json.containsKey((Object)"approvals")) {
            this.approvals = new ArrayList<Approval>();
            JSONArray eventApprovals = json.getJSONArray("approvals");
            for (i = 0; i < eventApprovals.size(); ++i) {
                this.approvals.add(new Approval(eventApprovals.getJSONObject(i)));
            }
        }
        if (json.containsKey((Object)"parents")) {
            this.parents = new ArrayList<String>();
            JSONArray eventParents = json.getJSONArray("parents");
            for (i = 0; i < eventParents.size(); ++i) {
                this.parents.add(eventParents.getString(i));
            }
        }
    }

    public List<String> getParents() {
        return this.parents;
    }

    public String getNumber() {
        return this.number;
    }

    public List<? extends Approval> getApprovals() {
        return this.approvals;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public GerritChangeKind getKind() {
        return this.kind;
    }

    public void setKind(GerritChangeKind kind) {
        this.kind = kind;
    }

    public Account getUploader() {
        return this.uploader;
    }

    public Account getAuthor() {
        return this.author;
    }

    public void setUploader(Account uploader) {
        this.uploader = uploader;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date date) {
        this.createdOn = date;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatchSet other = (PatchSet)obj;
        if (this.number == null ? other.number != null : !this.number.equals(other.number)) {
            return false;
        }
        return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.number != null ? this.number.hashCode() : 0);
        hash = 79 * hash + (this.revision != null ? this.revision.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "PatchSet: " + this.getNumber();
    }
}

