/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.dto.attr;

import com.sonymobile.tools.gerrit.gerritevents.GerritJsonEventFactory;
import com.sonymobile.tools.gerrit.gerritevents.GerritQueryHandler;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritChangeStatus;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritJsonDTO;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Account;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Comment;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.Topic;
import com.sonymobile.tools.gerrit.gerritevents.helpers.FileHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class Change
implements GerritJsonDTO {
    private String project;
    private String branch;
    private Topic topicObject;
    private transient String topic;
    private List<String> hashtags;
    private String id;
    private String number;
    private String subject;
    private String commitMessage;
    private Account owner;
    private String url;
    private Date createdOn;
    private Date lastUpdated;
    private List<Comment> comments;
    private List<String> files;
    private GerritChangeStatus status;
    private boolean wip;
    private boolean _private;

    private Object readResolve() {
        if (StringUtils.isNotEmpty((String)this.topic)) {
            this.topicObject = new Topic(this.topic);
            this.topic = null;
        }
        if (this.topicObject != null && StringUtils.isEmpty((String)this.topicObject.getName())) {
            this.topicObject = null;
        }
        return this;
    }

    public Change() {
    }

    public Change(JSONObject json) {
        this.fromJson(json);
    }

    @Override
    public void fromJson(JSONObject json) {
        String topicName;
        int i;
        this.project = GerritJsonEventFactory.getString(json, "project");
        this.branch = GerritJsonEventFactory.getString(json, "branch");
        this.id = GerritJsonEventFactory.getString(json, "id");
        this.number = GerritJsonEventFactory.getString(json, "number");
        this.subject = GerritJsonEventFactory.getString(json, "subject");
        this.createdOn = GerritJsonEventFactory.getDate(json, "createdOn");
        this.lastUpdated = GerritJsonEventFactory.getDate(json, "lastUpdated");
        if (json.containsKey((Object)"owner")) {
            this.owner = new Account(json.getJSONObject("owner"));
        }
        if (json.containsKey((Object)"comments")) {
            this.comments = new ArrayList<Comment>();
            JSONArray eventApprovals = json.getJSONArray("comments");
            for (i = 0; i < eventApprovals.size(); ++i) {
                this.comments.add(new Comment(eventApprovals.getJSONObject(i)));
            }
        }
        if (json.containsKey((Object)"commitMessage")) {
            this.commitMessage = GerritJsonEventFactory.getString(json, "commitMessage");
        }
        if (json.containsKey((Object)"topic") && StringUtils.isNotEmpty((String)(topicName = GerritJsonEventFactory.getString(json, "topic")))) {
            this.topicObject = new Topic(topicName);
        }
        if (json.containsKey((Object)"hashtags")) {
            JSONArray tags = json.getJSONArray("hashtags");
            this.hashtags = new ArrayList<String>(tags.size());
            for (i = 0; i < tags.size(); ++i) {
                this.hashtags.add(tags.getString(i));
            }
        } else {
            this.hashtags = Collections.emptyList();
        }
        this.url = GerritJsonEventFactory.getString(json, "url");
        this.status = GerritChangeStatus.fromString(GerritJsonEventFactory.getString(json, "status"));
        this.wip = GerritJsonEventFactory.getBoolean(json, "wip", false);
        this._private = GerritJsonEventFactory.getBoolean(json, "private", false);
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public GerritChangeStatus getStatus() {
        return this.status;
    }

    public void setStatus(GerritChangeStatus status) {
        this.status = status;
    }

    public Topic getTopicObject() {
        return this.topicObject;
    }

    public String getTopic() {
        if (this.topicObject == null) {
            return null;
        }
        return this.topicObject.getName();
    }

    public void setTopic(String topicName) {
        this.topicObject = new Topic(topicName);
    }

    public void setTopicObject(Topic topicObject) {
        this.topicObject = topicObject;
    }

    public List<String> getHashtags() {
        return this.hashtags;
    }

    public void setHashtags(List<String> hashtags) {
        this.hashtags = hashtags;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Account getOwner() {
        return this.owner;
    }

    public void setOwner(Account owner) {
        this.owner = owner;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date date) {
        this.createdOn = date;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date date) {
        this.lastUpdated = date;
    }

    public boolean isWip() {
        return this.wip;
    }

    public void setWip(boolean wip) {
        this.wip = wip;
    }

    public boolean isPrivate() {
        return this._private;
    }

    public void setPrivate(boolean _private) {
        this._private = _private;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Change other = (Change)obj;
        if (this.project == null ? other.project != null : !this.project.equals(other.project)) {
            return false;
        }
        if (this.branch == null ? other.branch != null : !this.branch.equals(other.branch)) {
            return false;
        }
        if (this.number == null ? other.number != null : !this.number.equals(other.number)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.project != null ? this.project.hashCode() : 0);
        hash = 29 * hash + (this.branch != null ? this.branch.hashCode() : 0);
        hash = 29 * hash + (this.number != null ? this.number.hashCode() : 0);
        hash = 29 * hash + (this.id != null ? this.id.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "Change-Id for #" + this.getNumber() + ": " + this.getId();
    }

    public String getChangeInfo(String preText) {
        StringBuilder s = new StringBuilder();
        s.append(preText + "\n");
        s.append("Subject: " + this.getSubject() + "\n");
        s.append("Project: " + this.getProject() + "  " + this.getBranch() + "  " + this.getId() + "\n");
        s.append("Link:    " + this.getUrl() + "\n");
        return s.toString();
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    public List<String> getFiles(GerritQueryHandler gerritQueryHandler) {
        if (this.files == null) {
            this.files = FileHelper.getFilesByChange(gerritQueryHandler, this.id);
        }
        return this.files;
    }
}

