/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.dto;

import com.sonymobile.tools.gerrit.gerritevents.dto.GerritJsonEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeAbandoned;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeMerged;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeRestored;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.CommentAdded;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.DraftPublished;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.HashtagsChanged;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.MergeFailed;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.PatchsetNotified;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.PrivateStateChanged;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ProjectCreated;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.RefReplicated;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.RefReplicationDone;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.RefUpdated;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.RerunCheck;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ReviewerAdded;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.TopicChanged;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.VoteDeleted;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.WipStateChanged;
import java.util.LinkedList;

public enum GerritEventType {
    PATCHSET_CREATED("patchset-created", true, PatchsetCreated.class),
    DRAFT_PUBLISHED("draft-published", true, DraftPublished.class),
    CHANGE_ABANDONED("change-abandoned", true, ChangeAbandoned.class),
    CHANGE_MERGED("change-merged", true, ChangeMerged.class),
    CHANGE_RESTORED("change-restored", true, ChangeRestored.class),
    COMMENT_ADDED("comment-added", true, CommentAdded.class),
    REF_UPDATED("ref-updated", true, RefUpdated.class),
    REF_REPLICATED("ref-replicated", true, RefReplicated.class),
    REF_REPLICATION_DONE("ref-replication-done", true, RefReplicationDone.class),
    PATCHSET_NOTIFIED("patchset-notified", true, PatchsetNotified.class),
    PROJECT_CREATED("project-created", true, ProjectCreated.class),
    TOPIC_CHANGED("topic-changed", true, TopicChanged.class),
    REVIEWER_ADDED("reviewer-added", true, ReviewerAdded.class),
    MERGE_FAILED("merge-failed", true, MergeFailed.class),
    PRIVATE_STATE_CHANGED("private-state-changed", true, PrivateStateChanged.class),
    WIP_STATE_CHANGED("wip-state-changed", true, WipStateChanged.class),
    HASHTAGS_CHANGED("hashtags-changed", true, HashtagsChanged.class),
    VOTE_DELETED("vote-deleted", true, VoteDeleted.class),
    RERUN_CHECK("rerun-check", true, RerunCheck.class);

    private String typeValue;
    private boolean interesting;
    private Class<? extends GerritJsonEvent> eventRepresentative;

    private GerritEventType(String typeValue, boolean interesting, Class<? extends GerritJsonEvent> eventRepresentative) {
        this.typeValue = typeValue;
        this.interesting = interesting;
        this.eventRepresentative = eventRepresentative;
    }

    public String getTypeValue() {
        return this.typeValue;
    }

    public boolean isInteresting() {
        return this.interesting;
    }

    public void setInteresting(boolean interesting) {
        this.interesting = interesting;
    }

    public Class<? extends GerritJsonEvent> getEventRepresentative() {
        return this.eventRepresentative;
    }

    public static GerritEventType findByTypeValue(String typeValue) {
        for (GerritEventType type : GerritEventType.values()) {
            if (!type.getTypeValue().equalsIgnoreCase(typeValue)) continue;
            return type;
        }
        return null;
    }

    public static GerritEventType[] getInterestingEventTypes() {
        LinkedList<GerritEventType> list = new LinkedList<GerritEventType>();
        for (GerritEventType type : GerritEventType.values()) {
            if (!type.isInteresting()) continue;
            list.add(type);
        }
        return list.toArray(new GerritEventType[list.size()]);
    }
}

