/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents;

import com.sonymobile.tools.gerrit.gerritevents.workers.GerritWorkersConfig;
import com.sonymobile.tools.gerrit.gerritevents.workers.cmd.AbstractSendCommandJob;
import com.sonymobile.tools.gerrit.gerritevents.workers.cmd.AbstractSendCommandJob2;
import com.sonymobile.tools.gerrit.gerritevents.workers.rest.AbstractRestCommandJob;
import com.sonymobile.tools.gerrit.gerritevents.workers.rest.AbstractRestCommandJob2;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GerritSendCommandQueue {
    private static final Logger logger = LoggerFactory.getLogger(GerritSendCommandQueue.class);
    private static GerritSendCommandQueue instance;
    private ThreadPoolExecutor executor = null;
    private static final String THREAD_PREFIX = "Gerrit-send-command-thread-";
    private static final int THREAD_KEEP_ALIVE_TIME = 20;
    public static final int SEND_QUEUE_SIZE_WARNING_THRESHOLD;
    private static final int WAIT_FOR_JOBS_SHUTDOWN_TIMEOUT = 30;

    private GerritSendCommandQueue() {
    }

    public static GerritSendCommandQueue getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Need to initialize the instance first!");
        }
        return instance;
    }

    public static void queue(AbstractSendCommandJob job) {
        GerritSendCommandQueue.getInstance().queueJob(job);
    }

    public static void queue(AbstractRestCommandJob job) {
        GerritSendCommandQueue.getInstance().queueJob(job);
    }

    public static void queue(AbstractSendCommandJob2 job) {
        GerritSendCommandQueue.getInstance().queueJob(job);
    }

    public static void queue(AbstractRestCommandJob2 job) {
        GerritSendCommandQueue.getInstance().queueJob(job);
    }

    public static int getQueueSize() {
        if (instance != null && GerritSendCommandQueue.instance.executor != null) {
            return GerritSendCommandQueue.instance.executor.getQueue().size();
        }
        return 0;
    }

    public void queueJob(Runnable job) {
        try {
            logger.debug("Queueing job {}", (Object)job);
            this.executor.submit(job);
        }
        catch (RejectedExecutionException e) {
            logger.error("Unable to queue a send-command-job! ", (Throwable)e);
        }
        this.checkQueueSize();
    }

    public Future<String> queueJob(Callable<String> job) {
        Future<String> future = null;
        try {
            logger.debug("Queueing job {}", job);
            future = this.executor.submit(job);
        }
        catch (RejectedExecutionException e) {
            logger.error("Unable to queue a send-command-job! ", (Throwable)e);
        }
        this.checkQueueSize();
        return future;
    }

    private void checkQueueSize() {
        int queueSize = GerritSendCommandQueue.getQueueSize();
        if (SEND_QUEUE_SIZE_WARNING_THRESHOLD > 0 && queueSize >= SEND_QUEUE_SIZE_WARNING_THRESHOLD) {
            logger.warn("The Gerrit send commands queue contains {} items! Something might be stuck, or your system can't process the commands fast enough. Try to increase the number of sending worker threads. Current thread-pool size: {}", (Object)queueSize, (Object)this.executor.getPoolSize());
            logger.info("Nr of active pool-threads: {}", (Object)this.executor.getActiveCount());
        }
    }

    protected void startQueue(GerritWorkersConfig config) {
        if (this.executor == null) {
            logger.debug("Starting the sending thread pool.");
            this.executor = new ThreadPoolExecutor(config.getNumberOfSendingWorkerThreads(), config.getNumberOfSendingWorkerThreads(), 20L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                private final ThreadFactory parent = Executors.defaultThreadFactory();
                private final AtomicInteger tid = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable task) {
                    Thread t = this.parent.newThread(task);
                    t.setName(GerritSendCommandQueue.THREAD_PREFIX + this.tid.getAndIncrement());
                    return t;
                }
            });
            this.executor.allowCoreThreadTimeOut(true);
            this.executor.prestartCoreThread();
            logger.info("SendQueue started! Current pool size: {}", (Object)this.executor.getPoolSize());
        } else {
            if (this.executor.getCorePoolSize() < config.getNumberOfSendingWorkerThreads()) {
                this.executor.setMaximumPoolSize(config.getNumberOfSendingWorkerThreads());
                this.executor.setCorePoolSize(config.getNumberOfSendingWorkerThreads());
            } else if (this.executor.getCorePoolSize() > config.getNumberOfSendingWorkerThreads()) {
                this.executor.setCorePoolSize(config.getNumberOfSendingWorkerThreads());
                this.executor.setMaximumPoolSize(config.getNumberOfSendingWorkerThreads());
            }
            logger.debug("SendQueue running. Current pool size: {}. Current Queue size: {}", (Object)this.executor.getPoolSize(), (Object)GerritSendCommandQueue.getQueueSize());
            logger.debug("Nr of active pool-threads: {}", (Object)this.executor.getActiveCount());
        }
    }

    public static synchronized void initialize(GerritWorkersConfig config) {
        if (instance == null) {
            instance = new GerritSendCommandQueue();
        }
        GerritSendCommandQueue.getInstance().startQueue(config);
    }

    public static synchronized void configure(GerritWorkersConfig config) {
        GerritSendCommandQueue.getInstance().startQueue(config);
    }

    public static void shutdown() {
        if (instance != null && GerritSendCommandQueue.instance.executor != null) {
            ThreadPoolExecutor pool = GerritSendCommandQueue.instance.executor;
            GerritSendCommandQueue.instance.executor = null;
            pool.shutdown();
            try {
                if (!pool.awaitTermination(30L, TimeUnit.SECONDS)) {
                    pool.shutdownNow();
                    if (!pool.awaitTermination(30L, TimeUnit.SECONDS)) {
                        logger.error("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        SEND_QUEUE_SIZE_WARNING_THRESHOLD = Integer.getInteger("gerritevents.GerritSendCommandQueue.SEND_QUEUE_SIZE_WARNING_THRESHOLD", 20);
    }
}

