/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents;

import com.sonymobile.tools.gerrit.gerritevents.GerritQueryHandler;
import com.sonymobile.tools.gerrit.gerritevents.ssh.Authentication;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnection;
import java.io.IOException;

public class GerritQueryHandlerWithPersistedConnection
extends GerritQueryHandler {
    private SshConnection activeConnection = null;

    public GerritQueryHandlerWithPersistedConnection(String gerritHostName, int gerritSshPort, String gerritProxy, Authentication authentication, int connectionTimeout) {
        super(gerritHostName, gerritSshPort, gerritProxy, authentication, connectionTimeout);
    }

    @Override
    protected SshConnection getConnection() throws IOException {
        if (!this.isPersistedConnectionValid()) {
            this.activeConnection = super.getConnection();
            logger.trace("SSH connection is not valid anymore, a new one was created.");
        }
        return this.activeConnection;
    }

    @Override
    protected void cleanupConnection(SshConnection ssh) {
    }

    private boolean isPersistedConnectionValid() {
        return this.activeConnection != null && this.activeConnection.isConnected();
    }

    public void disconnect() {
        if (this.isPersistedConnectionValid()) {
            this.activeConnection.disconnect();
            logger.trace("The persisted SSH connection was disconnected.");
        }
    }
}

