/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents;

import com.sonymobile.tools.gerrit.gerritevents.GerritConnectionConfig;
import com.sonymobile.tools.gerrit.gerritevents.GerritConnectionConfig2;
import com.sonymobile.tools.gerrit.gerritevents.GerritQueryException;
import com.sonymobile.tools.gerrit.gerritevents.ssh.Authentication;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnection;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnectionFactory;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritQueryHandler {
    protected static final Logger logger = LoggerFactory.getLogger(GerritQueryHandler.class);
    public static final String QUERY_COMMAND = "gerrit query";
    private final String gerritHostName;
    private final int gerritSshPort;
    private final String gerritProxy;
    private final Authentication authentication;
    private final int connectionTimeout;

    public GerritQueryHandler(String gerritHostName, int gerritSshPort, String gerritProxy, Authentication authentication, int connectionTimeout) {
        this.gerritHostName = gerritHostName;
        this.gerritSshPort = gerritSshPort;
        this.gerritProxy = gerritProxy;
        this.authentication = authentication;
        this.connectionTimeout = connectionTimeout;
    }

    public GerritQueryHandler(String gerritHostName, int gerritSshPort, String gerritProxy, Authentication authentication) {
        this(gerritHostName, gerritSshPort, gerritProxy, authentication, 0);
    }

    public GerritQueryHandler(GerritConnectionConfig config) {
        this(config.getGerritHostName(), config.getGerritSshPort(), "", config.getGerritAuthentication(), 0);
    }

    public GerritQueryHandler(GerritConnectionConfig2 config) {
        this(config.getGerritHostName(), config.getGerritSshPort(), config.getGerritProxy(), config.getGerritAuthentication(), 0);
    }

    public List<JSONObject> queryJava(String queryString) throws SshException, IOException, GerritQueryException {
        return this.queryJava(queryString, true, true, false, false);
    }

    public List<JSONObject> queryJava(String queryString, boolean getPatchSets, boolean getCurrentPatchSet, boolean getFiles) throws SshException, IOException, GerritQueryException {
        return this.queryJava(queryString, getPatchSets, getCurrentPatchSet, getFiles, false);
    }

    public List<JSONObject> queryJava(String queryString, boolean getPatchSets, boolean getCurrentPatchSet, boolean getFiles, boolean getCommitMessage) throws SshException, IOException, GerritQueryException {
        return this.queryJava(queryString, getPatchSets, getCurrentPatchSet, getFiles, getCommitMessage, false);
    }

    public List<JSONObject> queryJava(String queryString, boolean getPatchSets, boolean getCurrentPatchSet, boolean getFiles, boolean getCommitMessage, boolean getComments) throws SshException, IOException, GerritQueryException {
        final LinkedList<JSONObject> list = new LinkedList<JSONObject>();
        this.runQuery(queryString, getPatchSets, getCurrentPatchSet, getFiles, getCommitMessage, getComments, new LineVisitor(){

            @Override
            public void visit(String line) throws GerritQueryException {
                JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)line.trim());
                if (json.has("type") && "error".equalsIgnoreCase(json.getString("type"))) {
                    throw new GerritQueryException(json.getString("message"));
                }
                list.add(json);
            }
        });
        return list;
    }

    public List<JSONObject> queryFiles(String queryString) throws SshException, IOException, GerritQueryException {
        return this.queryJava(queryString, false, true, true, false);
    }

    public List<JSONObject> queryCurrentPatchSets(String queryString) throws SshException, IOException, GerritQueryException {
        return this.queryJava(queryString, false, true, false, false);
    }

    public List<String> queryJson(String queryString) throws SshException, IOException {
        return this.queryJson(queryString, true, true, false, false);
    }

    public List<String> queryJson(String queryString, boolean getPatchSets, boolean getCurrentPatchSet, boolean getFiles) throws SshException, IOException {
        return this.queryJson(queryString, getPatchSets, getCurrentPatchSet, getFiles, false);
    }

    public List<String> queryJson(String queryString, boolean getPatchSets, boolean getCurrentPatchSet, boolean getFiles, boolean getCommitMessage) throws SshException, IOException {
        final LinkedList<String> list = new LinkedList<String>();
        try {
            this.runQuery(queryString, getPatchSets, getCurrentPatchSet, getFiles, getCommitMessage, false, new LineVisitor(){

                @Override
                public void visit(String line) {
                    list.add(line.trim());
                }
            });
        }
        catch (GerritQueryException gqe) {
            logger.error("This should not have happened!", (Throwable)gqe);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQuery(String queryString, boolean getPatchSets, boolean getCurrentPatchSet, boolean getFiles, boolean getCommitMessage, boolean getComments, LineVisitor visitor) throws GerritQueryException, SshException, IOException {
        StringBuilder str = new StringBuilder(QUERY_COMMAND);
        str.append(" --format=JSON");
        if (getPatchSets) {
            str.append(" --patch-sets");
        }
        if (getCurrentPatchSet) {
            str.append(" --current-patch-set");
        }
        if (getFiles) {
            str.append(" --files");
        }
        if (getComments) {
            str.append(" --comments");
        }
        if (getCommitMessage) {
            str.append(" --commit-message");
        }
        str.append(" \"").append(queryString.replace("\"", "\\\"")).append("\"");
        SshConnection ssh = null;
        try {
            ssh = this.getConnection();
            BufferedReader reader = new BufferedReader(ssh.executeCommandReader(str.toString()));
            String incomingLine = null;
            while ((incomingLine = reader.readLine()) != null) {
                logger.trace("Incoming line: {}", (Object)incomingLine);
                visitor.visit(incomingLine);
            }
            logger.trace("Closing reader.");
            reader.close();
        }
        finally {
            this.cleanupConnection(ssh);
        }
    }

    protected SshConnection getConnection() throws IOException {
        return SshConnectionFactory.getConnection(this.gerritHostName, this.gerritSshPort, this.gerritProxy, this.authentication, this.connectionTimeout);
    }

    protected void cleanupConnection(SshConnection ssh) {
        if (ssh != null) {
            ssh.disconnect();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GerritQueryHandler)) {
            return false;
        }
        GerritQueryHandler gerritQueryHandler = (GerritQueryHandler)o;
        return Objects.equals(this.gerritHostName, gerritQueryHandler.gerritHostName) && this.gerritSshPort == gerritQueryHandler.gerritSshPort && Objects.equals(this.gerritProxy, gerritQueryHandler.gerritProxy) && Objects.equals(this.authentication, gerritQueryHandler.authentication) && this.connectionTimeout == gerritQueryHandler.connectionTimeout;
    }

    public int hashCode() {
        return Objects.hash(this.gerritHostName, this.gerritSshPort, this.gerritProxy, this.authentication, this.connectionTimeout);
    }

    static interface LineVisitor {
        public void visit(String var1) throws GerritQueryException;
    }
}

