/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents;

import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEventType;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritJsonEvent;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GerritJsonEventFactory {
    private static final Logger logger = LoggerFactory.getLogger(GerritJsonEventFactory.class);

    private GerritJsonEventFactory() {
    }

    public static GerritJsonEvent getEvent(JSONObject jsonObject) {
        GerritEventType type = GerritEventType.findByTypeValue(jsonObject.getString("type"));
        Class<? extends GerritJsonEvent> clazz = type.getEventRepresentative();
        GerritJsonEvent event = null;
        try {
            logger.debug("Interesting event with a class defined. Searching shorthand constructor.");
            Constructor<? extends GerritJsonEvent> constructor = clazz.getConstructor(JSONObject.class);
            event = constructor.newInstance(jsonObject);
            logger.trace("Event created from shorthand constructor.");
        }
        catch (NoSuchMethodException ex) {
            logger.debug("Constructor with JSONObject as parameter missing, trying default constructor.", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.debug("Error when using event constructor with JSONObject, trying default constructor.", (Throwable)ex);
        }
        if (event == null) {
            logger.debug("Trying default constructor.");
            try {
                event = clazz.newInstance();
                event.fromJson(jsonObject);
                logger.trace("Event created from default constructor");
            }
            catch (InstantiationException ex) {
                logger.error("Could not create an interesting GerritJsonEvent via default constructor (DESIGN ERROR).", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                logger.error("Could not create an interesting GerritJsonEvent via default constructor(DESIGN ERROR).", (Throwable)ex);
            }
        }
        logger.debug("Returning an event: {}", event);
        return event;
    }

    public static boolean isInterestingAndUsable(String jsonString) {
        return GerritJsonEventFactory.getJsonObjectIfInterestingAndUsable(jsonString) != null;
    }

    public static JSONObject getJsonObjectIfInterestingAndUsable(String jsonString) {
        logger.trace("finding event for jsonString: {}", (Object)jsonString);
        if (jsonString == null || jsonString.length() <= 0) {
            return null;
        }
        try {
            JSONObject jsonObject = (JSONObject)JSONSerializer.toJSON((Object)jsonString);
            logger.debug("Parsed a JSONObject");
            if (GerritJsonEventFactory.isInterestingAndUsable(jsonObject)) {
                return jsonObject;
            }
        }
        catch (Exception ex) {
            logger.warn("Unanticipated error when examining JSON String", (Throwable)ex);
        }
        return null;
    }

    @Deprecated
    public static boolean isInteresgingAndUsable(JSONObject json) {
        return GerritJsonEventFactory.isInterestingAndUsable(json);
    }

    public static boolean isInterestingAndUsable(JSONObject json) {
        try {
            if (json != null && json.get("type") != null) {
                logger.trace("It has a type");
                GerritEventType type = GerritEventType.findByTypeValue(json.getString("type"));
                logger.debug("Type found: {}", (Object)type);
                if (type != null && type.isInteresting() && type.getEventRepresentative() != null) {
                    logger.debug("It is interesting and usable.");
                    return true;
                }
            }
        }
        catch (Exception ex) {
            logger.warn("Unanticipated error when examining JSON String.");
        }
        return false;
    }

    public static GerritJsonEvent getEventIfInteresting(String jsonString) {
        logger.trace("finding event for jsonString: {}", (Object)jsonString);
        try {
            JSONObject jsonObject = GerritJsonEventFactory.getJsonObjectIfInterestingAndUsable(jsonString);
            if (jsonObject != null) {
                return GerritJsonEventFactory.getEvent(jsonObject);
            }
        }
        catch (Exception ex) {
            logger.warn("Unanticipated error when creating DTO representation of JSON string.", (Throwable)ex);
        }
        return null;
    }

    public static String getString(JSONObject json, String key, String defaultValue) {
        if (json.containsKey((Object)key)) {
            return json.getString(key);
        }
        return defaultValue;
    }

    public static String getString(JSONObject json, String key) {
        return GerritJsonEventFactory.getString(json, key, null);
    }

    public static boolean getBoolean(JSONObject json, String key, boolean defaultValue) {
        if (json.containsKey((Object)key)) {
            boolean result;
            try {
                result = json.getBoolean(key);
            }
            catch (JSONException ex) {
                result = defaultValue;
            }
            return result;
        }
        return defaultValue;
    }

    public static boolean getBoolean(JSONObject json, String key) {
        return GerritJsonEventFactory.getBoolean(json, key, false);
    }

    public static Date getDate(JSONObject json, String key) {
        return GerritJsonEventFactory.getDate(json, key, null);
    }

    public static Date getDate(JSONObject json, String key, Date defaultValue) {
        Date result = defaultValue;
        if (json.containsKey((Object)key)) {
            try {
                String secondsString = json.getString(key);
                Long milliseconds = TimeUnit.SECONDS.toMillis(Long.parseLong(secondsString));
                result = new Date(milliseconds);
            }
            catch (JSONException jSONException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }
}

