/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents;

import com.sonymobile.tools.gerrit.gerritevents.GerritEventListener;
import com.sonymobile.tools.gerrit.gerritevents.Handler;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Account;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Provider;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.CommentAdded;
import com.sonymobile.tools.gerrit.gerritevents.workers.Coordinator;
import com.sonymobile.tools.gerrit.gerritevents.workers.EventThread;
import com.sonymobile.tools.gerrit.gerritevents.workers.GerritEventWork;
import com.sonymobile.tools.gerrit.gerritevents.workers.JSONEventWork;
import com.sonymobile.tools.gerrit.gerritevents.workers.StreamEventsStringWork;
import com.sonymobile.tools.gerrit.gerritevents.workers.Work;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritHandler
implements Coordinator,
Handler {
    private static final Logger logger = LoggerFactory.getLogger(GerritHandler.class);
    private int numberOfWorkerThreads;
    private final Set<GerritEventListener> gerritEventListeners = new CopyOnWriteArraySet<GerritEventListener>();
    private Map<String, String> ignoreEMails = new ConcurrentHashMap<String, String>();
    private ThreadPoolExecutor executor = null;
    private int threadKeepAliveTime = 1200;
    private static final String THREAD_PREFIX = "Gerrit Worker EventThread_";
    private static final int WAIT_FOR_JOBS_SHUTDOWN_TIMEOUT = 30;
    private final ScheduledExecutorService whitelistScheduler = Executors.newScheduledThreadPool(1);
    private final String whitelistLocation = "gerrit.whitelist.location";
    private final String whitelistTimeout = "gerrit.whitelist.timeout";
    private final String whitelistTimeoutDefault = "30";
    private static volatile HashMap<String, Object> whitelist = new HashMap();
    private static final int WORK_QUEUE_SIZE_WARNING_THRESHOLD = Integer.getInteger("gerritevents.GerritSendCommandQueue.WORK_QUEUE_SIZE_WARNING_THRESHOLD", 40);

    public GerritHandler() {
        this(3, 1200);
    }

    public GerritHandler(int numberOfWorkerThreads) {
        this(numberOfWorkerThreads, 1200);
        this.scheduleGerritWhitelistRead();
    }

    public GerritHandler(int numberOfWorkerThreads, int threadKeepAliveTime) {
        this.numberOfWorkerThreads = numberOfWorkerThreads;
        this.threadKeepAliveTime = Math.max(10, threadKeepAliveTime);
        this.startQueue();
    }

    @Deprecated
    protected EventThread createEventThread(String threadName) {
        return new EventThread(this, threadName);
    }

    protected ThreadFactory getThreadFactory() {
        return new ThreadFactory(){
            private final ThreadFactory parent = Executors.defaultThreadFactory();
            private final AtomicInteger tid = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable task) {
                Thread t = this.parent.newThread(task);
                t.setName(GerritHandler.THREAD_PREFIX + this.tid.getAndIncrement());
                return t;
            }
        };
    }

    protected void startQueue() {
        if (this.executor == null) {
            logger.debug("Starting the receiving thread pool.");
            this.executor = new ThreadPoolExecutor(this.numberOfWorkerThreads, this.numberOfWorkerThreads, (long)this.threadKeepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.getThreadFactory());
            this.executor.allowCoreThreadTimeOut(true);
            this.executor.prestartCoreThread();
            logger.info("ReceiveQueue started! Current pool size: {}", (Object)this.executor.getPoolSize());
        } else {
            if (this.executor.getCorePoolSize() < this.numberOfWorkerThreads) {
                this.executor.setMaximumPoolSize(this.numberOfWorkerThreads);
                this.executor.setCorePoolSize(this.numberOfWorkerThreads);
            } else if (this.executor.getCorePoolSize() > this.numberOfWorkerThreads) {
                this.executor.setCorePoolSize(this.numberOfWorkerThreads);
                this.executor.setMaximumPoolSize(this.numberOfWorkerThreads);
            }
            logger.info("ReceiveQueue running. Current pool size: {}. Current Queue size: {}", (Object)this.executor.getPoolSize(), (Object)this.getQueueSize());
            logger.info("Nr of active pool-threads: {}", (Object)this.executor.getActiveCount());
        }
    }

    int getLargestPoolSize() {
        return this.executor.getLargestPoolSize();
    }

    public String getIgnoreEMail(String serverName) {
        if (serverName != null) {
            return this.ignoreEMails.get(serverName);
        }
        return null;
    }

    public void setIgnoreEMail(String serverName, String ignoreEMail) {
        if (serverName != null) {
            if (ignoreEMail != null) {
                this.ignoreEMails.put(serverName, ignoreEMail);
            } else {
                this.ignoreEMails.remove(serverName);
            }
        }
    }

    @Override
    public void post(String data) {
        this.post(data, null);
    }

    @Override
    public void post(JSONObject json) {
        this.post(json, null);
    }

    @Override
    public void post(String data, Provider provider) {
        logger.debug("Trigger event string: {}", (Object)data);
        this.post(new StreamEventsStringWork(data, provider));
    }

    @Override
    public void post(JSONObject json, Provider provider) {
        logger.debug("Trigger event json object: {}", (Object)json);
        this.post(new JSONEventWork(json, provider));
    }

    @Override
    public void post(GerritEvent event) {
        logger.debug("Internally trigger event: {}", (Object)event);
        this.post(new GerritEventWork(event));
    }

    public int getQueueSize() {
        return this.executor.getQueue().size();
    }

    private void post(Work work) {
        logger.trace("putting work on queue.");
        this.queueWork(work);
        this.checkQueueSize();
    }

    private void queueWork(Work work) {
        try {
            logger.debug("Queueing work {}", (Object)work);
            this.executor.submit(new EventWorker(work, this));
        }
        catch (RejectedExecutionException e) {
            logger.error("Unable to queue a received event! ", (Throwable)e);
        }
        this.checkQueueSize();
    }

    private void checkQueueSize() {
        int queueSize = this.getQueueSize();
        if (WORK_QUEUE_SIZE_WARNING_THRESHOLD > 0 && queueSize >= WORK_QUEUE_SIZE_WARNING_THRESHOLD) {
            logger.warn("The Gerrit incoming events queue contains {} items! Something might be stuck, or your system can't process the commands fast enough. Try to increase the number of receiving worker threads. Current thread-pool size: {}", (Object)queueSize, (Object)this.executor.getPoolSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(GerritEventListener listener) {
        GerritHandler gerritHandler = this;
        synchronized (gerritHandler) {
            if (!this.gerritEventListeners.add(listener)) {
                logger.warn("The listener was doubly-added: {}", (Object)listener);
            }
        }
    }

    @Deprecated
    public void addEventListeners(Map<Integer, GerritEventListener> listeners) {
        this.addEventListeners(listeners.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListeners(Collection<? extends GerritEventListener> listeners) {
        GerritHandler gerritHandler = this;
        synchronized (gerritHandler) {
            this.gerritEventListeners.addAll(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(GerritEventListener listener) {
        GerritHandler gerritHandler = this;
        synchronized (gerritHandler) {
            this.gerritEventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GerritEventListener> removeAllEventListeners() {
        GerritHandler gerritHandler = this;
        synchronized (gerritHandler) {
            HashSet<GerritEventListener> listeners = new HashSet<GerritEventListener>(this.gerritEventListeners);
            this.gerritEventListeners.clear();
            return listeners;
        }
    }

    public int getEventListenersCount() {
        return this.gerritEventListeners.size();
    }

    public Set<GerritEventListener> getGerritEventListenersView() {
        return Collections.unmodifiableSet(this.gerritEventListeners);
    }

    public int getNumberOfWorkerThreads() {
        return this.numberOfWorkerThreads;
    }

    public void setNumberOfWorkerThreads(int numberOfWorkerThreads) {
        this.numberOfWorkerThreads = numberOfWorkerThreads;
        this.startQueue();
    }

    public int getThreadKeepAliveTime() {
        return this.threadKeepAliveTime;
    }

    public void setThreadKeepAliveTime(int threadKeepAliveTime) {
        this.threadKeepAliveTime = Math.max(10, threadKeepAliveTime);
        this.executor.setKeepAliveTime(threadKeepAliveTime, TimeUnit.SECONDS);
    }

    @Override
    public BlockingQueue<Work> getWorkQueue() {
        LinkedBlockingQueue<Work> queue = new LinkedBlockingQueue<Work>();
        BlockingQueue<Runnable> workQueue = this.executor.getQueue();
        for (Runnable r : workQueue) {
            if (!(r instanceof EventWorker)) continue;
            queue.add(((EventWorker)r).work);
        }
        return queue;
    }

    @Override
    public void notifyListeners(GerritEvent event) {
        if (event instanceof CommentAdded && this.ignoreEvent((CommentAdded)event)) {
            logger.trace("CommentAdded ignored");
            return;
        }
        for (GerritEventListener listener : this.gerritEventListeners) {
            try {
                this.notifyListener(listener, event);
            }
            catch (Exception ex) {
                logger.error("When notifying listener: {} about event: {}", (Object)listener, (Object)event);
                logger.error("Notify-error: ", (Throwable)ex);
            }
        }
    }

    private void notifyListener(GerritEventListener listener, GerritEvent event) {
        logger.trace("Notifying listener {} of event {}", (Object)listener, (Object)event);
        try {
            logger.trace("Reflecting closest method");
            Method method = listener.getClass().getMethod("gerritEvent", event.getClass());
            method.invoke((Object)listener, event);
        }
        catch (IllegalAccessException ex) {
            logger.debug("Not allowed to invoke the reflected method. Calling default.", (Throwable)ex);
            listener.gerritEvent(event);
        }
        catch (IllegalArgumentException ex) {
            logger.debug("Not allowed to invoke the reflected method with specified parameter (REFLECTION BUG). Calling default.", (Throwable)ex);
            listener.gerritEvent(event);
        }
        catch (InvocationTargetException ex) {
            logger.error("When notifying listener: {} about event: {}", (Object)listener, (Object)event);
            logger.error("Exception thrown during event handling.", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            logger.debug("No appropriate method found during reflection. Calling default.", (Throwable)ex);
            listener.gerritEvent(event);
        }
        catch (SecurityException ex) {
            logger.debug("Not allowed to reflect/invoke a method on this listener (DESIGN BUG). Calling default", (Throwable)ex);
            listener.gerritEvent(event);
        }
    }

    private boolean ignoreEvent(CommentAdded event) {
        String ignoreEMail;
        Account account = event.getAccount();
        if (account == null) {
            return false;
        }
        String accountEmail = account.getEmail();
        if (StringUtils.isEmpty((String)accountEmail)) {
            return false;
        }
        Provider provider = event.getProvider();
        return provider != null && StringUtils.isNotEmpty((String)(ignoreEMail = this.ignoreEMails.get(provider.getName()))) && accountEmail.endsWith(ignoreEMail);
    }

    public void shutdown(boolean join) {
        ThreadPoolExecutor pool = this.executor;
        this.executor = null;
        pool.shutdown();
        if (join) {
            try {
                if (!pool.awaitTermination(30L, TimeUnit.SECONDS)) {
                    pool.shutdownNow();
                    if (!pool.awaitTermination(30L, TimeUnit.SECONDS)) {
                        logger.error("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    @Deprecated
    public void triggerEvent(GerritEvent event) {
        this.post(event);
    }

    public void scheduleGerritWhitelistRead() {
        this.scheduleGerritWhitelistRead(System.getProperty("gerrit.whitelist.location"));
    }

    public void scheduleGerritWhitelistRead(final String location) {
        if (StringUtils.isEmpty((String)location)) {
            logger.info("config file for whitelist not found; will not filter events for processing");
            return;
        }
        Runnable whitelistReader = new Runnable(){

            @Override
            public void run() {
                String fileName = location;
                logger.debug("reading config file");
                try {
                    HashMap<String, Object> newWhitelist = new HashMap<String, Object>();
                    BufferedReader in = new BufferedReader(new FileReader(fileName));
                    String readLine = in.readLine();
                    while (StringUtils.isNotEmpty((String)readLine)) {
                        logger.debug("whitelisting: {}", (Object)readLine);
                        newWhitelist.put(readLine, null);
                        readLine = in.readLine();
                    }
                    whitelist = newWhitelist;
                }
                catch (FileNotFoundException ex) {
                    logger.error("Exception thrown during whitelist file read. File does not exist", (Throwable)ex);
                }
                catch (IOException ex) {
                    logger.error("Exception thrown during whitelist file read.", (Throwable)ex);
                }
            }
        };
        String whitelistTimeoutString = System.getProperty("gerrit.whitelist.timeout");
        if (StringUtils.isEmpty((String)whitelistTimeoutString)) {
            whitelistTimeoutString = "30";
        }
        this.whitelistScheduler.scheduleAtFixedRate(whitelistReader, 0L, Integer.parseInt(whitelistTimeoutString), TimeUnit.MINUTES);
    }

    public static HashMap<String, Object> getWhitelist() {
        return whitelist;
    }

    private static class EventWorker
    implements Runnable {
        Work work;
        Coordinator coordinator;

        public EventWorker(Work work, Coordinator coordinator) {
            this.work = work;
            this.coordinator = coordinator;
        }

        @Override
        public void run() {
            if (this.work instanceof StreamEventsStringWork) {
                this.workEvent(((StreamEventsStringWork)this.work).getLine());
            } else if (this.work instanceof JSONEventWork) {
                logger.debug("JSON project: {}", (Object)((JSONEventWork)this.work).getJson());
                this.workEvent(((JSONEventWork)this.work).getJson().toString());
            } else {
                this.work.perform(this.coordinator);
            }
        }

        private void workEvent(String line) {
            logger.debug("Line for project evaluation{},line");
            String project = this.getProjectNameFromJsonString(line);
            logger.debug("Project before filter: {}", (Object)project);
            if (this.isValidProject(project)) {
                this.work.perform(this.coordinator);
            } else {
                logger.debug("Ignoring event from: {}", (Object)project);
            }
        }

        private boolean isValidProject(String project) {
            if (GerritHandler.getWhitelist().isEmpty()) {
                return true;
            }
            return GerritHandler.getWhitelist().containsKey(project);
        }

        String getProjectNameFromJsonString(String data) {
            int indexOf = data.indexOf("project");
            if (indexOf >= 0) {
                indexOf += "project".length();
                indexOf = data.indexOf(58, indexOf);
                indexOf = data.indexOf(34, indexOf);
                int nextSeparator = data.indexOf(47, ++indexOf);
                int nextQuote = data.indexOf(34, indexOf);
                if (nextSeparator > 0 && nextSeparator < nextQuote) {
                    return data.substring(indexOf, nextSeparator);
                }
                return data.substring(indexOf, nextQuote);
            }
            return "";
        }
    }
}

