/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.sonymobile.tools.gerrit.gerritevents.ConnectionListener;
import com.sonymobile.tools.gerrit.gerritevents.Connector;
import com.sonymobile.tools.gerrit.gerritevents.GerritConnectionConfig;
import com.sonymobile.tools.gerrit.gerritevents.GerritConnectionConfig2;
import com.sonymobile.tools.gerrit.gerritevents.GerritConnectionEvent;
import com.sonymobile.tools.gerrit.gerritevents.GerritDefaultValues;
import com.sonymobile.tools.gerrit.gerritevents.GerritHandler;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Provider;
import com.sonymobile.tools.gerrit.gerritevents.ssh.Authentication;
import com.sonymobile.tools.gerrit.gerritevents.ssh.AuthenticationUpdater;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshAuthenticationException;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnectException;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnection;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnectionFactory;
import com.sonymobile.tools.gerrit.gerritevents.watchdog.StreamWatchdog;
import com.sonymobile.tools.gerrit.gerritevents.watchdog.WatchTimeExceptionData;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritConnection
extends Thread
implements Connector {
    public static final int CONNECT_SLEEP = 2000;
    public static final String CMD_STREAM_EVENTS = "gerrit stream-events";
    private static final String GERRIT_VERSION_PREFIX = "gerrit version ";
    private static final int SSH_RX_BUFFER_SIZE = 262400;
    private static final int SSH_RX_SLEEP_MILLIS = 100;
    public static final String GERRIT_PROTOCOL_SCHEME_NAME = "ssh";
    private static final Logger logger = LoggerFactory.getLogger(GerritConnection.class);
    private String gerritName;
    private String gerritHostName;
    private int gerritSshPort;
    private String gerritProxy;
    private Authentication authentication;
    private String gerritFrontEndUrl;
    private SshConnection sshConnection;
    private volatile boolean shutdownInProgress = false;
    private volatile boolean connected = false;
    private String gerritVersion = null;
    private int watchdogTimeoutSeconds;
    private WatchTimeExceptionData exceptionData;
    private StreamWatchdog watchdog;
    private int reconnectCallCount = 0;
    private GerritHandler handler;
    private AuthenticationUpdater authenticationUpdater = null;
    private final Set<ConnectionListener> listeners = new CopyOnWriteArraySet<ConnectionListener>();
    private int sshRxBufferSize = 262400;
    private StringBuilder eventBuffer = null;

    public GerritConnection() {
        this("", "", 29418, "", "", new Authentication(GerritDefaultValues.DEFAULT_GERRIT_AUTH_KEY_FILE, "", GerritDefaultValues.DEFAULT_GERRIT_AUTH_KEY_FILE_PASSWORD));
    }

    public GerritConnection(String gerritName, String gerritHostName, int gerritSshPort, Authentication authentication) {
        this(gerritName, gerritHostName, gerritSshPort, "", "", authentication);
    }

    public GerritConnection(String gerritName, GerritConnectionConfig config) {
        this(gerritName, config, "", 0, null);
    }

    public GerritConnection(String gerritName, GerritConnectionConfig2 config) {
        this(gerritName, config, config.getGerritProxy(), config.getWatchdogTimeoutSeconds(), config.getExceptionData());
    }

    public GerritConnection(String gerritName, GerritConnectionConfig config, String gerritProxy, int watchdogTimeoutSeconds, WatchTimeExceptionData exceptionData) {
        this(gerritName, config.getGerritHostName(), config.getGerritSshPort(), gerritProxy, config.getGerritFrontEndUrl(), config.getGerritAuthentication(), watchdogTimeoutSeconds, exceptionData);
    }

    public GerritConnection(String gerritName, String gerritHostName, int gerritSshPort, String gerritProxy, String gerritFrontEndUrl, Authentication authentication) {
        this(gerritName, gerritHostName, gerritSshPort, gerritProxy, gerritFrontEndUrl, authentication, 0, null);
    }

    public GerritConnection(String gerritName, String gerritHostName, int gerritSshPort, String gerritProxy, String gerritFrontEndUrl, Authentication authentication, int watchdogTimeoutSeconds, WatchTimeExceptionData exceptionData) {
        this.gerritName = gerritName;
        this.gerritHostName = gerritHostName;
        this.gerritSshPort = gerritSshPort;
        this.gerritProxy = gerritProxy;
        this.gerritFrontEndUrl = gerritFrontEndUrl;
        this.authentication = authentication;
        this.watchdogTimeoutSeconds = watchdogTimeoutSeconds;
        this.exceptionData = exceptionData;
    }

    public int setSshRxBufferSize(int size) {
        int prev = this.sshRxBufferSize;
        this.sshRxBufferSize = size;
        return prev;
    }

    public void setHandler(GerritHandler handler) {
        this.handler = handler;
    }

    public GerritHandler getHandler() {
        return this.handler;
    }

    public String getGerritVersion() {
        return this.gerritVersion;
    }

    public void addListener(ConnectionListener listener) {
        if (!this.listeners.add(listener)) {
            logger.warn("The connection listener was doubly-added: {}", (Object)listener);
        }
    }

    public void removeListener(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    public Set<ConnectionListener> getListenersView() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public void setAuthenticationUpdater(AuthenticationUpdater authenticationUpdater) {
        this.authenticationUpdater = authenticationUpdater;
    }

    private void nullifyWatchdog() {
        if (this.watchdog != null) {
            this.watchdog.shutdown();
            this.watchdog = null;
        }
    }

    private String getLine(CharBuffer cb) {
        String line = null;
        int pos = cb.position();
        int limit = cb.limit();
        cb.flip();
        for (int i = 0; i < cb.length(); ++i) {
            if (cb.charAt(i) != '\n') continue;
            line = this.getSubSequence(cb, 0, i).toString();
            cb.position(i + 1);
            break;
        }
        if (line != null) {
            cb.compact();
            if (this.eventBuffer != null) {
                this.eventBuffer.append(line);
                String eventString = this.eventBuffer.toString();
                this.eventBuffer = null;
                line = eventString;
            }
            line.trim();
        } else if (cb.length() > 0) {
            if (cb.length() == cb.capacity()) {
                if (this.eventBuffer == null) {
                    logger.debug("Encountered big event.");
                    this.eventBuffer = new StringBuilder();
                }
                this.eventBuffer.append(this.getSubSequence(cb, 0, pos));
            } else {
                cb.position(pos);
                cb.limit(limit);
            }
        } else {
            cb.clear();
        }
        return line;
    }

    @IgnoreJRERequirement
    private CharSequence getSubSequence(CharBuffer cb, int start, int end) {
        return cb.subSequence(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Starting Up " + this.gerritName);
        do {
            this.sshConnection = this.connect();
            if (this.sshConnection == null) {
                return;
            }
            if (this.watchdogTimeoutSeconds > 0 && this.exceptionData != null) {
                this.nullifyWatchdog();
                this.watchdog = new StreamWatchdog(this, this.watchdogTimeoutSeconds, this.exceptionData);
            }
            ChannelExec channel = null;
            try {
                Integer readCount;
                logger.trace("Executing stream-events command.");
                channel = this.sshConnection.executeCommandChannel(CMD_STREAM_EVENTS, false);
                if (channel == null) {
                    throw new IOException("Cannot open SSH channel.");
                }
                InputStreamReader reader = new InputStreamReader(channel.getInputStream(), "utf-8");
                channel.connect();
                CharBuffer cb = CharBuffer.allocate(this.sshRxBufferSize);
                this.notifyConnectionEstablished();
                Provider provider = new Provider(this.gerritName, this.gerritHostName, String.valueOf(this.gerritSshPort), GERRIT_PROTOCOL_SCHEME_NAME, this.gerritFrontEndUrl, this.getGerritVersionString());
                logger.info("Ready to receive data from Gerrit: " + this.gerritName);
                while ((readCount = Integer.valueOf(((Reader)reader).read(cb))) != -1) {
                    String line;
                    logger.debug("Read count from Gerrit stream: {}", (Object)String.valueOf(readCount));
                    int linecount = 0;
                    while ((line = this.getLine(cb)) != null) {
                        ++linecount;
                        logger.debug("Data-line from Gerrit: {}", (Object)line);
                        if (this.handler == null) continue;
                        this.handler.post(line, provider);
                    }
                    if (this.shutdownInProgress || GerritConnection.interrupted()) {
                        throw new InterruptedException("shutdown requested: " + this.shutdownInProgress);
                    }
                    if (readCount > 0 && this.watchdog != null) {
                        this.watchdog.signal();
                    }
                    if (!channel.isConnected() || !this.sshConnection.isConnected()) {
                        throw new IllegalStateException("SSH connection is already lost.");
                    }
                    if (readCount != 0 && linecount <= 0) continue;
                    GerritConnection.sleep(100L);
                }
            }
            catch (IOException ex) {
                logger.error("Stream events command error. ", (Throwable)ex);
            }
            catch (IllegalStateException ex) {
                logger.error("Unexpected disconnection occurred after initial moment of connection. ", (Throwable)ex);
            }
            catch (InterruptedException ex) {
                logger.error("Interrupted.", (Throwable)ex);
            }
            catch (JSchException ex) {
                logger.error("Error when establishing SSH connection. ", (Throwable)ex);
            }
            finally {
                this.nullifyWatchdog();
                if (channel != null && !channel.isClosed()) {
                    logger.trace("Close channel.");
                    try {
                        channel.disconnect();
                    }
                    catch (Exception ex) {
                        logger.warn("Error when disconnecting SSH command channel.", (Throwable)ex);
                    }
                }
                if (!this.sshConnection.isConnected()) {
                    this.sshConnection = null;
                }
                this.notifyConnectionDown();
            }
        } while (!this.shutdownInProgress);
        this.handler = null;
        logger.debug("End of GerritConnection Thread.");
    }

    private SshConnection connect() {
        if (this.sshConnection != null && this.sshConnection.isConnected()) {
            return this.sshConnection;
        }
        while (!this.shutdownInProgress) {
            SshConnection ssh = null;
            try {
                logger.debug("Connecting...");
                ssh = SshConnectionFactory.getConnection(this.gerritHostName, this.gerritSshPort, this.gerritProxy, this.authentication, this.authenticationUpdater);
                this.gerritVersion = this.formatVersion(ssh.executeCommand("gerrit version"));
                logger.debug("connection seems ok, returning it.");
                return ssh;
            }
            catch (SshConnectException sshConEx) {
                logger.error("Could not connect to Gerrit server! Host: {} Port: {}", (Object)this.gerritHostName, (Object)this.gerritSshPort);
                logger.error(" Proxy: {}", (Object)this.gerritProxy);
                logger.error(" User: {} KeyFile: {}", (Object)this.authentication.getUsername(), (Object)this.authentication.getPrivateKeyFile());
                logger.error("ConnectionException: ", (Throwable)sshConEx);
            }
            catch (SshAuthenticationException sshAuthEx) {
                logger.error("Could not authenticate to Gerrit server!\n\tUsername: {}\n\tKeyFile: {}\n\tPassword: {}", new Object[]{this.authentication.getUsername(), this.authentication.getPrivateKeyFile(), this.authentication.getPrivateKeyFilePassword()});
                logger.error("AuthenticationException: ", (Throwable)sshAuthEx);
            }
            catch (IOException ex) {
                logger.error("Could not connect to Gerrit server! Host: {} Port: {}", (Object)this.gerritHostName, (Object)this.gerritSshPort);
                logger.error(" Proxy: {}", (Object)this.gerritProxy);
                logger.error(" User: {} KeyFile: {}", (Object)this.authentication.getUsername(), (Object)this.authentication.getPrivateKeyFile());
                logger.error("IOException: ", (Throwable)ex);
            }
            if (ssh != null) {
                logger.trace("Disconnecting bad connection.");
                try {
                    ssh.disconnect();
                }
                catch (Exception ex) {
                    logger.warn("Error when disconnecting bad connection.", (Throwable)ex);
                }
                finally {
                    ssh = null;
                }
            }
            if (this.shutdownInProgress) continue;
            logger.trace("Sleeping for a bit.");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                logger.warn("Got interrupted while sleeping.", (Throwable)ex);
            }
        }
        return null;
    }

    private String formatVersion(String version) {
        if (version == null) {
            return version;
        }
        String[] split = version.split(GERRIT_VERSION_PREFIX);
        if (split.length < 2) {
            return version.trim();
        }
        return split[1].trim();
    }

    private String getGerritVersionString() {
        String version = this.getGerritVersion();
        if (version == null) {
            version = "";
        }
        return version;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public String getGerritHostName() {
        return this.gerritHostName;
    }

    public void setGerritHostName(String gerritHostName) {
        this.gerritHostName = gerritHostName;
    }

    public int getGerritSshPort() {
        return this.gerritSshPort;
    }

    public void setGerritSshPort(int gerritSshPort) {
        this.gerritSshPort = gerritSshPort;
    }

    public String getGerritProxy() {
        return this.gerritProxy;
    }

    public void setGerritProxy(String gerritProxy) {
        this.gerritProxy = gerritProxy;
    }

    private void setShutdownInProgress() {
        this.shutdownInProgress = true;
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void reconnect() {
        ++this.reconnectCallCount;
        this.nullifyWatchdog();
        this.sshConnection.disconnect();
    }

    public int getReconnectCallCount() {
        return this.reconnectCallCount;
    }

    public void shutdown(boolean join) {
        this.setShutdownInProgress();
        this.nullifyWatchdog();
        if (this.sshConnection != null) {
            logger.info("Shutting down the ssh connection.");
            try {
                this.sshConnection.disconnect();
            }
            catch (Exception ex) {
                logger.warn("Error when disconnecting sshConnection.", (Throwable)ex);
            }
        }
        if (join) {
            try {
                this.join();
            }
            catch (InterruptedException ex) {
                logger.warn("Got interrupted while waiting for shutdown.", (Throwable)ex);
            }
        }
    }

    public void notifyListeners(GerritConnectionEvent event) {
        for (ConnectionListener listener : this.listeners) {
            try {
                switch (event) {
                    case GERRIT_CONNECTION_ESTABLISHED: {
                        listener.connectionEstablished();
                        break;
                    }
                    case GERRIT_CONNECTION_DOWN: {
                        listener.connectionDown();
                        break;
                    }
                }
            }
            catch (Exception ex) {
                logger.error("ConnectionListener threw Exception. ", (Throwable)ex);
            }
        }
    }

    protected void notifyConnectionDown() {
        this.connected = false;
        this.notifyListeners(GerritConnectionEvent.GERRIT_CONNECTION_DOWN);
    }

    protected void notifyConnectionEstablished() {
        this.connected = true;
        this.notifyListeners(GerritConnectionEvent.GERRIT_CONNECTION_ESTABLISHED);
    }
}

