/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.echarts.SeriesBuilder;
import io.jenkins.plugins.forensics.miner.CommitStatistics;
import io.jenkins.plugins.forensics.miner.ForensicsBuildAction;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import java.util.HashMap;
import java.util.Map;

class RelativeCountForensicsSeriesBuilder
extends SeriesBuilder<ForensicsBuildAction> {
    static final String AUTHORS_KEY = "authors";
    static final String FILES_KEY = "files";
    static final String COMMITS_KEY = "commits";

    RelativeCountForensicsSeriesBuilder() {
    }

    protected Map<String, Integer> computeSeries(ForensicsBuildAction current) {
        CommitStatistics commitStatistics = current.getTotalLinesOfCode() == 0 ? ((RepositoryStatistics)current.getResult()).getLatestStatistics() : current.getCommitStatistics();
        return RelativeCountForensicsSeriesBuilder.computeRelativeCountStatistics(commitStatistics);
    }

    static Map<String, Integer> computeRelativeCountStatistics(CommitStatistics commitStatistics) {
        HashMap<String, Integer> series = new HashMap<String, Integer>();
        series.put(AUTHORS_KEY, commitStatistics.getAuthorCount());
        series.put(FILES_KEY, commitStatistics.getFilesCount());
        series.put(COMMITS_KEY, commitStatistics.getCommitCount());
        return series;
    }
}

