/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.datatables.TableModel;
import io.jenkins.plugins.forensics.miner.FileStatistics;
import io.jenkins.plugins.forensics.miner.Messages;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class ForensicsTableModel
extends TableModel {
    private final RepositoryStatistics statistics;

    ForensicsTableModel(RepositoryStatistics statistics) {
        this.statistics = statistics;
    }

    public String getId() {
        return "forensics";
    }

    public List<TableColumn> getColumns() {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        TableColumn.ColumnBuilder builder = new TableColumn.ColumnBuilder();
        columns.add(builder.withHeaderLabel(Messages.Table_Column_File()).withDataPropertyKey("fileName").withHeaderClass(TableColumn.ColumnCss.NONE).build());
        columns.add(builder.withHeaderLabel(Messages.Table_Column_AuthorsSize()).withDataPropertyKey("authorsSize").withHeaderClass(TableColumn.ColumnCss.NONE).build());
        columns.add(builder.withHeaderLabel(Messages.Table_Column_CommitsSize()).withDataPropertyKey("commitsSize").withHeaderClass(TableColumn.ColumnCss.NONE).build());
        columns.add(builder.withHeaderLabel(Messages.Table_Column_LastCommit()).withDataPropertyKey("modifiedAt").withHeaderClass(TableColumn.ColumnCss.DATE).build());
        columns.add(builder.withHeaderLabel(Messages.Table_Column_AddedAt()).withDataPropertyKey("addedAt").withHeaderClass(TableColumn.ColumnCss.DATE).build());
        columns.add(builder.withHeaderLabel(Messages.Table_Column_LOC()).withDataPropertyKey("linesOfCode").withHeaderClass(TableColumn.ColumnCss.NONE).build());
        columns.add(builder.withHeaderLabel(Messages.Table_Column_Churn()).withDataPropertyKey("churn").withHeaderClass(TableColumn.ColumnCss.NONE).build());
        return columns;
    }

    public List<Object> getRows() {
        return this.statistics.getFileStatistics().stream().map(ForensicsRow::new).collect(Collectors.toList());
    }

    public static class ForensicsRow {
        private final FileStatistics fileStatistics;

        ForensicsRow(FileStatistics fileStatistics) {
            this.fileStatistics = fileStatistics;
        }

        public String getFileName() {
            String fullPath = this.fileStatistics.getFileName();
            return ((ContainerTag)((ContainerTag)((ContainerTag)((ContainerTag)TagCreator.a().withHref("fileName." + fullPath.hashCode())).withText(FilenameUtils.getName((String)fullPath)).attr("data-bs-toggle", (Object)"tooltip")).attr("data-bs-placement", (Object)"left")).withTitle(fullPath)).render();
        }

        public int getAuthorsSize() {
            return this.fileStatistics.getNumberOfAuthors();
        }

        public int getCommitsSize() {
            return this.fileStatistics.getNumberOfCommits();
        }

        public int getModifiedAt() {
            return this.fileStatistics.getLastModificationTime();
        }

        public int getAddedAt() {
            return this.fileStatistics.getCreationTime();
        }

        public int getLinesOfCode() {
            return this.fileStatistics.getLinesOfCode();
        }

        public int getChurn() {
            return this.fileStatistics.getAbsoluteChurn();
        }
    }
}

