/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.delta;

import io.jenkins.plugins.forensics.delta.Change;
import io.jenkins.plugins.forensics.delta.ChangeEditType;
import io.jenkins.plugins.forensics.delta.FileEditType;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileChanges
implements Serializable {
    private static final long serialVersionUID = 6135245877389921937L;
    private final String fileName;
    private final String oldFileName;
    private final String fileContent;
    private final FileEditType fileEditType;
    private final EnumMap<ChangeEditType, Set<Change>> changes;

    public FileChanges(String fileName, String oldFileName, String fileContent, FileEditType fileEditType, Map<ChangeEditType, Set<Change>> changes) {
        this.fileName = fileName;
        this.oldFileName = oldFileName;
        this.fileContent = fileContent;
        this.fileEditType = fileEditType;
        this.changes = this.createMap(changes);
    }

    private EnumMap<ChangeEditType, Set<Change>> createMap(Map<ChangeEditType, Set<Change>> existingChanges) {
        if (existingChanges.isEmpty()) {
            return new EnumMap<ChangeEditType, Set<Change>>(ChangeEditType.class);
        }
        return new EnumMap<ChangeEditType, Set<Change>>(existingChanges);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getOldFileName() {
        return this.oldFileName;
    }

    public String getFileContent() {
        return this.fileContent;
    }

    public FileEditType getFileEditType() {
        return this.fileEditType;
    }

    public Map<ChangeEditType, Set<Change>> getChanges() {
        return this.createMap(this.changes);
    }

    public Set<Change> getChangesByType(ChangeEditType changeEditType) {
        if (this.changes.containsKey((Object)changeEditType)) {
            return this.changes.get((Object)changeEditType);
        }
        return new HashSet<Change>();
    }

    public void addChange(Change change) {
        ChangeEditType changeEditType = change.getEditType();
        if (this.changes.containsKey((Object)changeEditType)) {
            this.changes.get((Object)changeEditType).add(change);
        } else {
            this.changes.put(change.getEditType(), Stream.of(change).collect(Collectors.toSet()));
        }
    }

    public Set<Integer> getModifiedLines() {
        return this.changes.values().stream().flatMap(Collection::stream).map(this::getModifiedLinesForChange).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<Integer> getModifiedLinesForChange(Change filter) {
        if (filter.getEditType() == ChangeEditType.INSERT || filter.getEditType() == ChangeEditType.REPLACE) {
            HashSet<Integer> lines = new HashSet<Integer>();
            for (int line = filter.getFromLine(); line <= filter.getToLine(); ++line) {
                lines.add(line);
            }
            return lines;
        }
        return Set.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileChanges that = (FileChanges)o;
        return Objects.equals(this.fileName, that.fileName) && Objects.equals(this.oldFileName, that.oldFileName) && Objects.equals(this.fileContent, that.fileContent) && this.fileEditType == that.fileEditType && Objects.equals(this.changes, that.changes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileName, this.oldFileName, this.fileContent, this.fileEditType, this.changes});
    }
}

