/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.forensics.miner.CommitDiffItem;
import io.jenkins.plugins.forensics.miner.CommitStatistics;
import io.jenkins.plugins.forensics.miner.FileStatistics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.apache.commons.lang3.StringUtils;

public class RepositoryStatistics
implements Serializable {
    private static final long serialVersionUID = 8L;
    @CheckForNull
    private Map<String, FileStatistics> statisticsPerFile;
    private transient Map<String, FileStatistics> statisticsMapping = new HashMap<String, FileStatistics>();
    private Collection<FileStatistics> fileStatistics = new ArrayList<FileStatistics>();
    private String latestCommitId;
    private CommitStatistics statistics = new CommitStatistics();
    private int totalLinesOfCode;
    private int totalChurn;

    public RepositoryStatistics() {
        this("");
    }

    public RepositoryStatistics(String latestCommitId) {
        this.latestCommitId = latestCommitId;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Deserialization of instances that do not have all fields yet")
    protected Object readResolve() {
        if (this.latestCommitId == null) {
            this.latestCommitId = "";
        }
        if (this.statisticsPerFile == null) {
            this.statisticsMapping = new HashMap<String, FileStatistics>();
            this.fileStatistics.forEach(s -> this.statisticsMapping.put(s.getFileName(), (FileStatistics)s));
        } else {
            this.statisticsMapping = this.statisticsPerFile;
            this.statisticsPerFile = null;
        }
        return this;
    }

    protected Object writeReplace() {
        this.fileStatistics = new ArrayList<FileStatistics>(this.statisticsMapping.values());
        return this;
    }

    public boolean isEmpty() {
        return this.statisticsMapping.isEmpty();
    }

    public String getLatestCommitId() {
        return this.latestCommitId;
    }

    public boolean hasLatestCommitId() {
        return StringUtils.isNotBlank((CharSequence)this.latestCommitId);
    }

    public int size() {
        return this.statisticsMapping.size();
    }

    public boolean contains(String fileName) {
        return this.statisticsMapping.containsKey(fileName);
    }

    public Set<String> getFiles() {
        return Collections.unmodifiableSet(this.statisticsMapping.keySet());
    }

    public Collection<FileStatistics> getFileStatistics() {
        return Collections.unmodifiableCollection(this.statisticsMapping.values());
    }

    public Map<String, FileStatistics> getMapping() {
        return Collections.unmodifiableMap(this.statisticsMapping);
    }

    public FileStatistics get(String fileName) {
        if (this.contains(fileName)) {
            return this.statisticsMapping.get(fileName);
        }
        throw new NoSuchElementException("No information for file %s stored".formatted(fileName));
    }

    public void addAll(List<CommitDiffItem> commits) {
        FileStatistics.FileStatisticsBuilder builder = new FileStatistics.FileStatisticsBuilder();
        for (CommitDiffItem commit : commits) {
            if (commit.isDelete()) {
                this.statisticsMapping.remove(commit.getOldPath());
                continue;
            }
            if (commit.isMove()) {
                FileStatistics existing = this.statisticsMapping.remove(commit.getOldPath());
                if (existing == null) {
                    this.statisticsMapping.putIfAbsent(commit.getNewPath(), builder.build(commit.getNewPath()));
                } else {
                    this.statisticsMapping.put(commit.getNewPath(), existing);
                }
                this.statisticsMapping.get(commit.getNewPath()).inspectCommit(commit);
                continue;
            }
            this.statisticsMapping.putIfAbsent(commit.getNewPath(), builder.build(commit.getNewPath()));
            this.statisticsMapping.get(commit.getNewPath()).inspectCommit(commit);
        }
        this.statistics = new CommitStatistics(commits);
        this.updateTotalLoc();
    }

    public void addAll(Collection<FileStatistics> additionalStatistics) {
        additionalStatistics.forEach(this::add);
    }

    public void addAll(RepositoryStatistics additionalStatistics) {
        this.addAll(additionalStatistics.getFileStatistics());
    }

    public void add(FileStatistics additionalStatistics) {
        this.statisticsMapping.merge(additionalStatistics.getFileName(), additionalStatistics, this::merge);
        this.updateTotalLoc();
    }

    private void updateTotalLoc() {
        this.totalLinesOfCode = this.sum(FileStatistics::getLinesOfCode);
        this.totalChurn = this.sum(FileStatistics::getAbsoluteChurn);
    }

    private int sum(ToIntFunction<FileStatistics> property) {
        return this.statisticsMapping.values().stream().mapToInt(property).sum();
    }

    private FileStatistics merge(FileStatistics existing, FileStatistics additional) {
        existing.inspectCommits(additional.getCommits());
        return existing;
    }

    public int getTotalChurn() {
        return this.totalChurn;
    }

    public int getTotalLinesOfCode() {
        return this.totalLinesOfCode;
    }

    public CommitStatistics getLatestStatistics() {
        return this.statistics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryStatistics that = (RepositoryStatistics)o;
        return this.statisticsMapping.equals(that.statisticsMapping) && this.latestCommitId.equals(that.latestCommitId);
    }

    public int hashCode() {
        return Objects.hash(this.statisticsMapping, this.latestCommitId);
    }
}

