/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.echarts.Build;
import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.LinesChartModel;
import hudson.model.InvisibleAction;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.echarts.AsyncConfigurableTrendChart;
import io.jenkins.plugins.forensics.miner.AddedVersusDeletedLinesCommitStatisticsSeriesBuilder;
import io.jenkins.plugins.forensics.miner.AddedVersusDeletedLinesTrendChart;
import io.jenkins.plugins.forensics.miner.CommitStatisticsBuildAction;
import io.jenkins.plugins.forensics.miner.RelativeCountCommitStatisticsSeriesBuilder;
import io.jenkins.plugins.forensics.miner.RelativeCountTrendChart;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class CommitStatisticsJobAction
extends InvisibleAction
implements AsyncConfigurableTrendChart {
    private static final JacksonFacade JACKSON_FACADE = new JacksonFacade();
    private final String scmKey;
    private final Job<?, ?> owner;

    CommitStatisticsJobAction(Job<?, ?> owner, String scmKey) {
        this.owner = owner;
        this.scmKey = scmKey;
    }

    @JavaScriptMethod
    public String getConfigurableBuildTrendModel(String configuration) {
        return new JacksonFacade().toJson((Object)this.createChartModel(configuration));
    }

    private LinesChartModel createChartModel(String configuration) {
        ChartModelConfiguration modelConfiguration = ChartModelConfiguration.fromJson((String)configuration);
        ChartType chart = this.getChart(configuration);
        Iterable<? extends BuildResult<CommitStatisticsBuildAction>> buildHistory = this.createBuildHistory(modelConfiguration.getBuildCount());
        if (chart == ChartType.DELTA) {
            return new AddedVersusDeletedLinesTrendChart().create(buildHistory, modelConfiguration, new AddedVersusDeletedLinesCommitStatisticsSeriesBuilder());
        }
        return new RelativeCountTrendChart().create(buildHistory, modelConfiguration, new RelativeCountCommitStatisticsSeriesBuilder());
    }

    private ChartType getChart(String configuration) {
        String type = JACKSON_FACADE.getString(configuration, "chartType", "delta");
        for (ChartType chartType : ChartType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)chartType.name())) continue;
            return chartType;
        }
        return ChartType.DELTA;
    }

    private Iterable<? extends BuildResult<CommitStatisticsBuildAction>> createBuildHistory(int buildCount) {
        ArrayList<BuildResult> history = new ArrayList<BuildResult>();
        for (Run run = this.owner.getLastCompletedBuild(); run != null; run = run.getPreviousBuild()) {
            Optional<CommitStatisticsBuildAction> latestAction = run.getActions(CommitStatisticsBuildAction.class).stream().filter(a -> this.scmKey.equals(a.getScmKey())).findAny();
            if (latestAction.isPresent()) {
                int buildTimeInSeconds = (int)(run.getTimeInMillis() / 1000L);
                Build build = new Build(run.getNumber(), run.getDisplayName(), buildTimeInSeconds);
                history.add(new BuildResult(build, (Object)latestAction.get()));
            }
            if (buildCount > 0 && history.size() >= buildCount) break;
        }
        return history;
    }

    public boolean isTrendVisible() {
        Iterable<? extends BuildResult<CommitStatisticsBuildAction>> results = this.createBuildHistory(2);
        Iterator<? extends BuildResult<CommitStatisticsBuildAction>> iterator = results.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        return iterator.hasNext();
    }

    static enum ChartType {
        DELTA,
        COUNT;

    }
}

