/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.blame;

import edu.hm.hafner.util.FilteredLog;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import io.jenkins.plugins.forensics.blame.Blamer;
import io.jenkins.plugins.forensics.util.ScmResolver;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public abstract class BlamerFactory
implements ExtensionPoint {
    public abstract Optional<Blamer> createBlamer(SCM var1, Run<?, ?> var2, FilePath var3, TaskListener var4, FilteredLog var5);

    public static Blamer findBlamer(Run<?, ?> run, Collection<FilePath> scmDirectories, TaskListener listener, FilteredLog logger) {
        return scmDirectories.stream().map(directory -> BlamerFactory.findBlamer(run, directory, listener, logger)).flatMap(Optional::stream).findFirst().orElseGet(() -> BlamerFactory.createNullBlamer(logger));
    }

    public static Blamer findBlamer(String scm, Run<?, ?> run, FilePath workTree, TaskListener listener, FilteredLog logger) {
        Collection<? extends SCM> scms = new ScmResolver().getScms(run, scm);
        if (scms.isEmpty()) {
            logger.logInfo("-> no SCM found");
            return new Blamer.NullBlamer();
        }
        return BlamerFactory.findAllExtensions().stream().map(blamerFactory -> blamerFactory.createBlamer((SCM)scms.iterator().next(), run, workTree, listener, logger)).flatMap(Optional::stream).findFirst().orElseGet(() -> BlamerFactory.createNullBlamer(logger));
    }

    private static Blamer createNullBlamer(FilteredLog logger) {
        if (BlamerFactory.findAllExtensions().isEmpty()) {
            logger.logInfo("-> No blamer installed yet. You need to install the 'git-forensics' plugin to enable blaming for Git.");
        } else {
            logger.logInfo("-> No suitable blamer found.");
        }
        return new Blamer.NullBlamer();
    }

    private static Optional<Blamer> findBlamer(Run<?, ?> run, FilePath workTree, TaskListener listener, FilteredLog logger) {
        SCM scm = new ScmResolver().getScm(run);
        return BlamerFactory.findAllExtensions().stream().map(blamerFactory -> blamerFactory.createBlamer(scm, run, workTree, listener, logger)).flatMap(Optional::stream).findFirst();
    }

    private static List<BlamerFactory> findAllExtensions() {
        return new JenkinsFacade().getExtensionsFor(BlamerFactory.class);
    }
}

