/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.fontawesome;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import io.jenkins.plugins.fontawesome.SvgTag;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public final class FontAwesomeIcons {
    private static final String SVG_FILE_ENDING = ".svg";
    private static final String IMAGES_SYMBOLS_PATH = "images/symbols/";
    private static final String FONT_AWESOME_API_PLUGIN = "font-awesome-api";
    private static final String ICON_CLASS_NAME_PATTERN = "symbol-%s plugin-font-awesome-api";

    public static String getIconClassName(String icon) {
        return String.format(ICON_CLASS_NAME_PATTERN, icon);
    }

    public static Map<String, String> getAvailableIcons() {
        return FontAwesomeIcons.getIconsFromClasspath(null);
    }

    public static Map<String, String> getAvailableIcons(@CheckForNull SvgTag.FontAwesomeStyle filter) {
        return FontAwesomeIcons.getIconsFromClasspath(filter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> getIconsFromClasspath(@CheckForNull SvgTag.FontAwesomeStyle filter) {
        Enumeration<URL> urls = FontAwesomeIcons.class.getClassLoader().getResources(IMAGES_SYMBOLS_PATH);
        while (urls.hasMoreElements()) {
            Map<String, String> map;
            URL url = urls.nextElement();
            if (!StringUtils.contains((CharSequence)url.toExternalForm(), (CharSequence)FONT_AWESOME_API_PLUGIN)) continue;
            URI uri = url.toURI();
            if (!StringUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"jar")) return FontAwesomeIcons.filterIcons(Paths.get(uri), filter);
            FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            try {
                map = FontAwesomeIcons.filterIcons(fileSystem.getPath(IMAGES_SYMBOLS_PATH, new String[0]), filter);
                if (fileSystem == null) return map;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem == null) throw throwable;
                    try {
                        fileSystem.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException exception) {
                    throw new IllegalStateException("Unable to read available icons: Resource unavailable.", exception);
                }
            }
            fileSystem.close();
            return map;
        }
        throw new IllegalStateException("Unable to find icons: Resource unavailable.");
    }

    private static Map<String, String> filterIcons(Path iconFolder, @CheckForNull SvgTag.FontAwesomeStyle filter) throws IOException {
        return FontAwesomeIcons.createIconStream(iconFolder, filter).filter(Objects::nonNull).filter(icon -> icon.getFileName() != null).filter(FontAwesomeIcons::isSvgImage).filter(icon -> icon.getParent() != null).filter(icon -> icon.getParent().getFileName() != null).sorted().map(FontAwesomeIcons::createFileName).collect(Collectors.toMap(icon -> icon, FontAwesomeIcons::getIconClassName));
    }

    private static Stream<Path> createIconStream(Path iconFolder, @CheckForNull SvgTag.FontAwesomeStyle filter) throws IOException {
        if (filter == null) {
            return Files.walk(iconFolder, 2, new FileVisitOption[0]);
        }
        return Files.walk(iconFolder.resolve(filter.name().toLowerCase(Locale.ENGLISH)), 1, new FileVisitOption[0]);
    }

    private static String createFileName(Path icon) {
        return String.valueOf(icon.getParent().getFileName()) + "/" + StringUtils.removeEnd((String)icon.getFileName().toString(), (String)SVG_FILE_ENDING);
    }

    private static boolean isSvgImage(Path path) {
        return StringUtils.endsWith((CharSequence)path.getFileName().toString(), (CharSequence)SVG_FILE_ENDING);
    }

    private FontAwesomeIcons() {
    }
}

