/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.clean;

import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.CallbackEvent;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.command.clean.CleanExecutor;
import org.flywaydb.core.internal.command.clean.CleanModeConfigurationExtension;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.PlainExecutionTemplate;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;

public class CleanModeCleanExecutor
extends CleanExecutor {
    private final String cleanMode;

    public CleanModeCleanExecutor(Connection connection, Database database, SchemaHistory schemaHistory, CallbackExecutor<Event> callbackExecutor, String cleanMode) {
        super(connection, database, schemaHistory, callbackExecutor);
        this.cleanMode = cleanMode;
    }

    public void clean(Schema defaultSchema, Schema[] schemas, CleanResult cleanResult, List<String> dropSchemas) {
        try {
            this.connection.changeCurrentSchemaTo(defaultSchema);
            this.clean(schemas, cleanResult, dropSchemas);
        }
        catch (FlywayException e) {
            this.callbackExecutor.onEvent((CallbackEvent)Event.AFTER_CLEAN_ERROR);
            throw e;
        }
    }

    protected void doCleanSchema(Schema schema) {
        if (CleanModeConfigurationExtension.Mode.ALL.name().equalsIgnoreCase(this.cleanMode)) {
            new PlainExecutionTemplate(true).execute(() -> {
                schema.clean();
                return null;
            });
        } else {
            super.doCleanSchema(schema);
        }
    }
}

