/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.classpath;

import java.util.Collection;
import lombok.Generated;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.scanner.ClasspathLocationHandler;
import org.flywaydb.core.internal.scanner.LocationScannerCache;
import org.flywaydb.core.internal.scanner.ResourceNameCache;
import org.flywaydb.core.internal.scanner.classpath.ClassPathScanner;

public class ClasspathLocationHandlerImpl
implements ClasspathLocationHandler {
    private final String prefix = "classpath:";
    private final ResourceNameCache resourceNameCache = new ResourceNameCache();
    private final LocationScannerCache locationScannerCache = new LocationScannerCache();

    @Override
    public Collection<LoadableResource> scanForResources(Location location, Configuration configuration) {
        ClassPathScanner<JavaMigration> classPathScanner = new ClassPathScanner<JavaMigration>(JavaMigration.class, configuration.getClassLoader(), configuration.getEncoding(), location, this.resourceNameCache, this.locationScannerCache, configuration.isFailOnMissingLocations(), configuration.isStream());
        return classPathScanner.scanForResources();
    }

    @Override
    public <I> Collection<Class<? extends I>> scanForClasses(Class<I> clazz, Location location, Configuration configuration) {
        ClassPathScanner<I> classPathScanner = new ClassPathScanner<I>(clazz, configuration.getClassLoader(), configuration.getEncoding(), location, this.resourceNameCache, this.locationScannerCache, configuration.isFailOnMissingLocations(), configuration.isStream());
        return classPathScanner.scanForClasses();
    }

    @Override
    public boolean handlesWildcards() {
        return true;
    }

    @Override
    public String getPathSeparator() {
        return "/";
    }

    @Override
    public String normalizePath(String path) {
        String pathWithoutPrefix = path.startsWith("/") ? path.substring(1) : path;
        return pathWithoutPrefix.endsWith("/") ? pathWithoutPrefix.substring(0, pathWithoutPrefix.length() - 1) : pathWithoutPrefix;
    }

    @Override
    @Generated
    public String getPrefix() {
        return this.prefix;
    }
}

