/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesystem_scm;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class SimpleAntWildcardFilter
extends AbstractFileFilter {
    private Pattern wildcardPattern;

    public SimpleAntWildcardFilter(String antWildcard) {
        String line = antWildcard;
        line = line.replace('\\', '/');
        String[] list = line.split("/");
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            if ("**".equals(s)) {
                buf.append("(/.*)?");
                continue;
            }
            s = s.replace(".", "\\.");
            s = s.replace('?', '.');
            s = s.replace("*", "[^\\/]*");
            if (buf.length() == 0) {
                if (s.length() == 0 || '/' == s.charAt(0) || s.matches("[a-zA-Z]\\:")) {
                    buf.append('^');
                } else {
                    buf.append('/');
                }
            } else {
                buf.append('/');
            }
            buf.append(s);
        }
        buf.append('$');
        String regexStr = buf.toString();
        this.wildcardPattern = Pattern.compile(regexStr, 2);
    }

    public Pattern getPattern() {
        return this.wildcardPattern;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String fullPath = file.getAbsolutePath();
        fullPath = fullPath.replace('\\', '/');
        return this.wildcardPattern.matcher(fullPath).find();
    }
}

