/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesystem_scm;

import hudson.FilePath;
import hudson.os.PosixException;
import hudson.plugins.filesystem_scm.FolderDiff;
import hudson.remoting.VirtualChannel;
import hudson.tools.JDKInstaller;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RemoteFolderDiff<T>
extends FolderDiff<T> {
    private static final long serialVersionUID = 5823948572938475938L;
    protected StringBuffer buf = new StringBuffer();
    protected long lastBuildTime;
    protected long lastSuccessfulBuildTime;
    protected boolean verboseLogging = true;

    public long getLastBuildTime() {
        return this.lastBuildTime;
    }

    public void setLastBuildTime(long lastBuildTime) {
        this.lastBuildTime = lastBuildTime;
    }

    public long getLastSuccessfulBuildTime() {
        return this.lastSuccessfulBuildTime;
    }

    public void setVerboseLogging(boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }

    public void setLastSuccessfulBuildTime(long lastSuccessfulBuildTime) {
        this.lastSuccessfulBuildTime = lastSuccessfulBuildTime;
    }

    @Override
    protected void log(String msg) {
        if (this.verboseLogging) {
            this.buf.append(msg).append("\n");
        }
    }

    @Override
    protected void copyFile(File src, File dst) throws IOException {
        FilePath srcpath = new FilePath(src);
        FilePath dstpath = new FilePath(dst);
        try {
            RemoteFolderDiff.changeDestinationPropertiesOnUnixSytem(dstpath, RemoteFolderDiff.isUnix());
            srcpath.copyToWithPermission(dstpath);
        }
        catch (InterruptedException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static void changeDestinationPropertiesOnUnixSytem(FilePath dstpath, boolean isUnix) throws IOException, InterruptedException, PosixException {
        int mode;
        if (isUnix && dstpath.exists() && ((mode = dstpath.mode()) & 0x80) == 0) {
            dstpath.chmod(mode | 0x80);
        }
    }

    private static boolean isUnix() {
        boolean isUnix = false;
        try {
            isUnix = JDKInstaller.Platform.WINDOWS != JDKInstaller.Platform.current();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isUnix;
    }

    public String getLog() {
        return this.buf.toString();
    }

    public static class CheckOut
    extends RemoteFolderDiff<List<FolderDiff.Entry>> {
        private static final long serialVersionUID = 1L;

        @Override
        public List<FolderDiff.Entry> invoke(File workspace, VirtualChannel channel) throws IOException {
            this.setDstPath(workspace.getAbsolutePath());
            List<FolderDiff.Entry> newFiles = this.getNewOrModifiedFiles(this.lastBuildTime, false);
            List<FolderDiff.Entry> delFiles = this.getFiles2Delete(false);
            ArrayList<FolderDiff.Entry> files = new ArrayList<FolderDiff.Entry>();
            files.addAll(newFiles);
            files.addAll(delFiles);
            return files;
        }
    }

    public static class PollChange
    extends RemoteFolderDiff<Boolean> {
        private static final long serialVersionUID = 1L;

        @Override
        public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
            this.setDstPath(workspace.getAbsolutePath());
            List<FolderDiff.Entry> newFiles = this.getNewOrModifiedFiles(this.lastBuildTime, true);
            if (newFiles.size() > 0) {
                return Boolean.TRUE;
            }
            if (-1L == this.lastSuccessfulBuildTime) {
                return Boolean.FALSE;
            }
            List<FolderDiff.Entry> delFiles = this.getFiles2Delete(true);
            return delFiles.size() > 0;
        }
    }
}

