/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesystem_scm;

import hudson.plugins.filesystem_scm.SimpleAntWildcardFilter;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class FolderDiff<T>
extends MasterToSlaveFileCallable<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String srcPath;
    private String dstPath;
    private boolean ignoreHidden;
    private boolean filterEnabled = false;
    private boolean includeFilter;
    private String[] filters;
    private Set<String> allowDeleteList;
    private int newCount = 0;
    private int modifiedCount = 0;
    private int deletedCount = 0;

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public void setDstPath(String dstPath) {
        this.dstPath = dstPath;
    }

    public void setIgnoreHidden(boolean ignoreHidden) {
        this.ignoreHidden = ignoreHidden;
    }

    public void setIncludeFilter(String[] filters) {
        this.filterEnabled = true;
        this.includeFilter = true;
        this.filters = filters;
    }

    public void setExcludeFilter(String[] filters) {
        this.filterEnabled = true;
        this.includeFilter = false;
        this.filters = filters;
    }

    public void setAllowDeleteList(Set<String> allowDeleteList) {
        this.allowDeleteList = allowDeleteList;
    }

    public int getNewCount() {
        return this.newCount;
    }

    public int getModifiedCount() {
        return this.modifiedCount;
    }

    public int getDeletedCount() {
        return this.deletedCount;
    }

    @Deprecated
    public List<Entry> getNewOrModifiedFiles(long time, boolean breakOnceFound, boolean testRun) {
        ArrayList<Entry> entries = new ArrayList();
        try {
            entries = this.getNewOrModifiedFiles(time, breakOnceFound);
        }
        catch (IOException e) {
            this.log(e);
        }
        return entries;
    }

    public List<Entry> getNewOrModifiedFiles(long time, boolean breakOnceFound) throws IOException {
        File src = new File(this.srcPath);
        File dst = new File(this.dstPath);
        ArrayList<Entry> list = new ArrayList<Entry>();
        if (src.isDirectory()) {
            Iterator it = FileUtils.iterateFiles((File)src, (IOFileFilter)this.createAntPatternFileFilter(), (IOFileFilter)this.getDirFilter());
            while (it.hasNext()) {
                File file = (File)it.next();
                String relativeName = FolderDiff.getRelativeName(file.getAbsolutePath(), src.getAbsolutePath());
                File tmp = new File(dst, relativeName);
                boolean newOrModified = true;
                if (!tmp.exists()) {
                    list.add(this.createAndLogg(relativeName, Entry.Type.NEW));
                } else if (FileUtils.isFileNewer((File)file, (long)time) || FileUtils.isFileNewer((File)file, (File)tmp)) {
                    list.add(this.createAndLogg(relativeName, Entry.Type.MODIFIED));
                } else {
                    newOrModified = false;
                }
                if (!newOrModified) continue;
                if (breakOnceFound) {
                    return list;
                }
                this.copyFile(file, tmp);
            }
        } else {
            throw new IOException(String.format("Source Directory not found! (%s)", src.getAbsolutePath()));
        }
        return list;
    }

    protected Entry createAndLogg(String relativeName, Entry.Type type) {
        switch (type.ordinal()) {
            case 1: {
                ++this.newCount;
                break;
            }
            case 0: {
                ++this.modifiedCount;
                break;
            }
            case 2: {
                ++this.deletedCount;
            }
        }
        this.log(type.name() + " file: " + relativeName);
        return new Entry(relativeName, type);
    }

    private AndFileFilter createAntPatternFileFilter() {
        AndFileFilter fileFilter = new AndFileFilter();
        fileFilter.addFileFilter(this.getDirFilter());
        if (this.filterEnabled && null != this.filters && this.filters.length > 0) {
            for (int i = 0; i < this.filters.length; ++i) {
                SimpleAntWildcardFilter iof = new SimpleAntWildcardFilter(this.filters[i]);
                if (this.includeFilter) {
                    fileFilter.addFileFilter((IOFileFilter)iof);
                    continue;
                }
                fileFilter.addFileFilter((IOFileFilter)new NotFileFilter((IOFileFilter)iof));
            }
        }
        return fileFilter;
    }

    @Deprecated
    public List<Entry> getDeletedFiles(long time, boolean breakOnceFound, boolean testRun) {
        ArrayList<Entry> entries = new ArrayList();
        try {
            entries = this.getFiles2Delete(breakOnceFound);
        }
        catch (IOException e) {
            this.log(e);
        }
        return entries;
    }

    public List<Entry> getFiles2Delete(boolean breakOnceFound) throws IOException {
        File src = new File(this.srcPath);
        File dst = new File(this.dstPath);
        IOFileFilter dirFilter = this.getDirFilter();
        AndFileFilter fileFilter = this.createAntPatternFileFilter();
        Collection allSources = new ArrayList();
        if (src.isDirectory()) {
            allSources = FileUtils.listFiles((File)src, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        }
        ArrayList<Entry> list = new ArrayList<Entry>();
        if (dst.isDirectory()) {
            Iterator it = FileUtils.iterateFiles((File)dst, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE);
            while (it.hasNext()) {
                File file = (File)it.next();
                String relativeName = FolderDiff.getRelativeName(file.getAbsolutePath(), dst.getAbsolutePath());
                File tmp = new File(src, relativeName);
                if (allSources.contains(tmp) || null != this.allowDeleteList && !this.allowDeleteList.contains(relativeName)) continue;
                list.add(this.createAndLogg(relativeName, Entry.Type.DELETED));
                if (breakOnceFound) {
                    return list;
                }
                try {
                    boolean deleted = this.deleteFile(file);
                    if (deleted) continue;
                    this.log("file.delete() failed: " + file.getAbsolutePath());
                }
                catch (SecurityException e) {
                    this.log("Can't delete " + file.getAbsolutePath(), e);
                }
            }
        }
        return list;
    }

    private IOFileFilter getDirFilter() {
        return this.ignoreHidden ? HiddenFileFilter.VISIBLE : TrueFileFilter.TRUE;
    }

    protected boolean deleteFile(File file) throws IOException {
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        return Files.deleteIfExists(path);
    }

    protected void log(Exception e) {
        this.log(FolderDiff.stackTraceToString(e));
    }

    protected void log(String msg, Exception e) {
        this.log(msg + "\n" + FolderDiff.stackTraceToString(e));
    }

    protected void log(String msg) {
        System.out.println(msg);
    }

    public static String stackTraceToString(Exception e) {
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        e.printStackTrace(writer);
        writer.flush();
        buf.flush();
        return buf.toString();
    }

    public static String getRelativeName(String fileName, String folderName) throws IOException {
        int x;
        String sep = File.separator;
        if (!((String)folderName).endsWith(sep)) {
            folderName = (String)folderName + sep;
        }
        if (0 != (x = fileName.indexOf((String)folderName))) {
            throw new IOException(fileName + " is not inside " + (String)folderName);
        }
        String relativeName = fileName.substring(((String)folderName).length());
        return relativeName;
    }

    protected void copyFile(File src, File dst) throws IOException {
        FileUtils.copyFile((File)src, (File)dst);
    }

    public T invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        throw new IOException("The method has not been overridden. Cannot execute");
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String filename;
        private Type type;

        public Entry() {
        }

        public Entry(String filename, Type type) {
            this.filename = filename;
            this.type = type;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }

        public static enum Type {
            MODIFIED,
            NEW,
            DELETED;

        }
    }
}

