/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesystem_scm;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.plugins.filesystem_scm.FilterSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class FilterSettings
implements Describable<FilterSettings> {
    private final boolean includeFilter;
    @Nonnull
    private final List<FilterSelector> selectors;

    @DataBoundConstructor
    public FilterSettings(boolean includeFilter, List<FilterSelector> selectors) {
        this.includeFilter = includeFilter;
        this.selectors = selectors != null ? selectors : Collections.emptyList();
    }

    @Nonnull
    public List<FilterSelector> getSelectors() {
        return Collections.unmodifiableList(this.selectors);
    }

    @Nonnull
    public List<String> getWildcards() {
        if (this.selectors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>(this.selectors.size());
        for (FilterSelector s : this.selectors) {
            res.add(s.getWildcard());
        }
        return res;
    }

    public boolean isIncludeFilter() {
        return this.includeFilter;
    }

    public Descriptor<FilterSettings> getDescriptor() {
        return Jenkins.getActiveInstance().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<FilterSettings> {
    }
}

