/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesystem_scm;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.plugins.filesystem_scm.SimpleAntWildcardFilter;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FilterSelector
implements Describable<FilterSelector> {
    private final String wildcard;

    @DataBoundConstructor
    public FilterSelector(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public Descriptor<FilterSelector> getDescriptor() {
        return Jenkins.getActiveInstance().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<FilterSelector> {
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckWildcard(@QueryParameter String value) {
            if (null == value || value.trim().length() == 0) {
                return FormValidation.ok();
            }
            if (value.startsWith("/") || value.startsWith("\\") || value.matches("[a-zA-Z]:.*")) {
                return FormValidation.error((String)"Pattern can't be an absolute path");
            }
            try {
                SimpleAntWildcardFilter filter = new SimpleAntWildcardFilter(value);
                return FormValidation.ok((String)("Pattern is correct: " + String.valueOf(filter.getPattern())));
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)"Invalid wildcard pattern");
            }
        }
    }
}

