/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesystem_scm;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.filesystem_scm.AllowDeleteList;
import hudson.plugins.filesystem_scm.ChangelogSet;
import hudson.plugins.filesystem_scm.FilterSelector;
import hudson.plugins.filesystem_scm.FilterSettings;
import hudson.plugins.filesystem_scm.FolderDiff;
import hudson.plugins.filesystem_scm.RemoteFolderDiff;
import hudson.plugins.filesystem_scm.RemoteListDir;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class FSSCM
extends SCM {
    private String path;
    private boolean clearWorkspace;
    private boolean verboseLogging = true;
    private transient boolean copyHidden;
    @Deprecated
    private transient boolean filterEnabled;
    @Deprecated
    private transient boolean includeFilter;
    @Deprecated
    private String[] filters;
    @CheckForNull
    private FilterSettings filterSettings;

    @DataBoundConstructor
    public FSSCM(String path, boolean clearWorkspace, boolean copyHidden, boolean verboseLogging, FilterSettings filterSettings) {
        this.path = path;
        this.clearWorkspace = clearWorkspace;
        this.copyHidden = copyHidden;
        this.verboseLogging = verboseLogging;
        this.filterSettings = filterSettings;
    }

    @Deprecated
    public FSSCM(String path, boolean clearWorkspace, boolean copyHidden, boolean filterEnabled, boolean includeFilter, String[] filters) {
        this(path, clearWorkspace, copyHidden, true, FSSCM.createFilterSettings(filterEnabled, includeFilter, filters));
    }

    private static FilterSettings createFilterSettings(boolean filterEnabled, boolean includeFilter, String[] filters) {
        FilterSettings filterSettings;
        if (filterEnabled) {
            ArrayList<FilterSelector> selectors = new ArrayList<FilterSelector>();
            if (null != filters) {
                for (String filter : filters) {
                    if (!StringUtils.isNotEmpty((String)filter)) continue;
                    selectors.add(new FilterSelector(filter));
                }
            }
            filterSettings = new FilterSettings(includeFilter, selectors);
        } else {
            filterSettings = null;
        }
        return filterSettings;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public void setVerboseLogging(boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }

    @Deprecated
    @CheckForNull
    public String[] getFilters() {
        if (this.filterSettings == null) {
            return new String[0];
        }
        List<String> wildcards = this.filterSettings.getWildcards();
        return wildcards.toArray(new String[wildcards.size()]);
    }

    public boolean isFilterEnabled() {
        return this.filterSettings != null;
    }

    public boolean isIncludeFilter() {
        return this.filterSettings != null && this.filterSettings.isIncludeFilter();
    }

    public boolean isClearWorkspace() {
        return this.clearWorkspace;
    }

    public boolean isCopyHidden() {
        return this.copyHidden;
    }

    @CheckForNull
    public FilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    protected Object readResolve() {
        if (this.filterEnabled && this.filterSettings == null) {
            List<FilterSelector> selectors;
            if (this.filters != null) {
                selectors = new ArrayList(this.filters.length);
                for (String value : this.filters) {
                    selectors.add(new FilterSelector(value));
                }
            } else {
                selectors = Collections.emptyList();
            }
            this.filterSettings = new FilterSettings(this.includeFilter, selectors);
        }
        return this;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ChangelogSet.XMLSerializer();
    }

    public void checkout(Run<?, ?> build, Launcher launcher, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState baseline) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        PrintStream log = launcher.getListener().getLogger();
        log.println("FSSCM.checkout " + this.path + " to " + String.valueOf(workspace));
        AllowDeleteList allowDeleteList = new AllowDeleteList(build.getParent().getRootDir());
        if (this.clearWorkspace) {
            log.println("FSSCM.clearWorkspace...");
            workspace.deleteRecursive();
        }
        if (allowDeleteList.fileExists()) {
            allowDeleteList.load();
        } else if (workspace.exists()) {
            Set existingFiles = (Set)workspace.act((FilePath.FileCallable)new RemoteListDir());
            allowDeleteList.setList(existingFiles);
        }
        RemoteFolderDiff.CheckOut callable = new RemoteFolderDiff.CheckOut();
        this.setupRemoteFolderDiff(callable, build.getParent(), allowDeleteList.getList());
        List list = (List)workspace.act((FilePath.FileCallable)callable);
        for (FolderDiff.Entry entry : list) {
            if (FolderDiff.Entry.Type.DELETED.equals((Object)entry.getType())) {
                allowDeleteList.remove(entry.getFilename());
                continue;
            }
            allowDeleteList.add(entry.getFilename());
        }
        allowDeleteList.save();
        String str = callable.getLog();
        if (str.length() > 0) {
            log.println(str);
        }
        this.printLogSummary(log, callable.getNewCount(), callable.getModifiedCount(), callable.getDeletedCount());
        this.processChangelog(build, changelogFile, list);
        log.println("FSSCM.check completed in " + FSSCM.formatDuration(System.currentTimeMillis() - start));
    }

    protected void processChangelog(Run<?, ?> build, File changelogFile, List<FolderDiff.Entry> list) throws FileNotFoundException {
        if (changelogFile != null) {
            ChangelogSet.XMLSerializer serializer = this.createXMLSerializer();
            ChangelogSet changeLogSet = new ChangelogSet(build, list);
            serializer.save(changeLogSet, changelogFile);
        }
    }

    private void printLogSummary(PrintStream log, int newCount, int modifiedCount, int deletedCount) {
        int total = newCount + modifiedCount + deletedCount;
        if (total > 0) {
            log.printf("Processed %d files (%d new, %d modified, %d deleted)%n", total, newCount, modifiedCount, deletedCount);
        }
    }

    private ChangelogSet.XMLSerializer createXMLSerializer() {
        return new ChangelogSet.XMLSerializer();
    }

    private boolean poll(Job<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        PrintStream log = launcher.getListener().getLogger();
        log.println("FSSCM.pollChange: " + this.path);
        AllowDeleteList allowDeleteList = new AllowDeleteList(project.getRootDir());
        if (allowDeleteList.fileExists()) {
            allowDeleteList.load();
        } else {
            Set existingFiles = (Set)workspace.act((FilePath.FileCallable)new RemoteListDir());
            allowDeleteList.setList(existingFiles);
        }
        RemoteFolderDiff.PollChange callable = new RemoteFolderDiff.PollChange();
        this.setupRemoteFolderDiff(callable, project, allowDeleteList.getList());
        boolean changed = (Boolean)workspace.act((FilePath.FileCallable)callable);
        String str = callable.getLog();
        if (str.length() > 0) {
            log.println(str);
        }
        log.println("FSSCM.pollChange return " + changed);
        log.println("FSSCM.poolChange completed in " + FSSCM.formatDuration(System.currentTimeMillis() - start));
        return changed;
    }

    private void setupRemoteFolderDiff(RemoteFolderDiff diff, Job<?, ?> project, Set<String> allowDeleteList) {
        Run lastBuild = project.getLastBuild();
        if (null == lastBuild) {
            diff.setLastBuildTime(0L);
            diff.setLastSuccessfulBuildTime(0L);
        } else {
            diff.setLastBuildTime(lastBuild.getTimestamp().getTimeInMillis());
            Run lastSuccessfulBuild = project.getLastSuccessfulBuild();
            if (null == lastSuccessfulBuild) {
                diff.setLastSuccessfulBuildTime(-1L);
            } else {
                diff.setLastSuccessfulBuildTime(lastSuccessfulBuild.getTimestamp().getTimeInMillis());
            }
        }
        diff.setSrcPath(this.path);
        diff.setIgnoreHidden(!this.copyHidden);
        diff.setVerboseLogging(this.verboseLogging);
        if (this.filterSettings != null) {
            if (this.filterSettings.isIncludeFilter()) {
                diff.setIncludeFilter(this.getFilters());
            } else {
                diff.setExcludeFilter(this.getFilters());
            }
        }
        diff.setAllowDeleteList(allowDeleteList);
    }

    private static String formatDuration(long diff) {
        if (diff < 60000L) {
            if (diff <= 1L) {
                return diff + " millisecond";
            }
            if (diff < 1000L) {
                return diff + " milliseconds";
            }
            if (diff < 2000L) {
                return (double)diff / 1000.0 + " second";
            }
            return (double)diff / 1000.0 + " seconds";
        }
        return DurationFormatUtils.formatDurationWords((long)diff, (boolean)true, (boolean)true);
    }

    public SCMRevisionState calcRevisionsFromBuild(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return SCMRevisionState.NONE;
    }

    public PollingResult compareRemoteRevisionWith(Job<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        if (launcher == null) {
            throw new IllegalArgumentException("Launcher cannot be null");
        }
        if (this.poll(project, launcher, workspace, listener)) {
            return PollingResult.SIGNIFICANT;
        }
        return PollingResult.NO_CHANGES;
    }

    @Extension
    @Symbol(value={"filesystem"})
    public static final class DescriptorImpl
    extends SCMDescriptor<FSSCM> {
        public DescriptorImpl() {
            super(FSSCM.class, null);
            this.load();
        }

        public String getDisplayName() {
            return "File System";
        }

        @Deprecated
        @Restricted(value={NoExternalUse.class})
        public FormValidation doFilterCheck(@QueryParameter String value) {
            return ((FilterSelector.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(FilterSelector.DescriptorImpl.class)).doCheckWildcard(value);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return true;
        }

        public boolean isApplicable(Job project) {
            return true;
        }
    }
}

