/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesystem_scm;

import hudson.model.Run;
import hudson.plugins.filesystem_scm.Changelog;
import hudson.plugins.filesystem_scm.FilesystemRepositoryBrowser;
import hudson.plugins.filesystem_scm.FolderDiff;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import hudson.util.XStream2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.xml.sax.SAXException;

public class ChangelogSet
extends ChangeLogSet<Changelog> {
    private List<Changelog> logs = new ArrayList<Changelog>();

    public ChangelogSet(Run<?, ?> build, List<FolderDiff.Entry> changes) {
        super(build, (RepositoryBrowser)new FilesystemRepositoryBrowser());
        if (!changes.isEmpty()) {
            this.logs.add(new Changelog(this, changes));
        }
    }

    public String getKind() {
        return "fs_scm";
    }

    public boolean isEmptySet() {
        return this.logs.isEmpty();
    }

    public Iterator<Changelog> iterator() {
        return Collections.unmodifiableList(this.logs).iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.logs == null ? 0 : this.logs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ChangelogSet other = (ChangelogSet)((Object)obj);
        return !(this.logs == null ? other.logs != null : !this.logs.equals(other.logs));
    }

    public static class XMLSerializer
    extends ChangeLogParser {
        private transient XStream2 xstream;

        private Object readResolve() {
            this.initXStream();
            return this;
        }

        public XMLSerializer() {
            this.initXStream();
        }

        private void initXStream() {
            this.xstream = new XStream2();
            this.xstream.alias("log", ChangelogSet.class);
            this.xstream.aliasField("changelogset", ChangelogSet.class, "changeLogSet");
            this.xstream.alias("changelog", Changelog.class);
            this.xstream.alias("path", Changelog.Path.class);
            this.xstream.omitField(ChangeLogSet.class, "build");
        }

        public ChangeLogSet<? extends ChangeLogSet.Entry> parse(Run build, RepositoryBrowser<?> browser, File changelogFile) throws IOException, SAXException {
            return this.parse(build, changelogFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChangelogSet parse(Run<?, ?> build, File file) throws FileNotFoundException {
            FileInputStream in = null;
            ChangelogSet out = null;
            try {
                in = new FileInputStream(file);
                out = (ChangelogSet)((Object)this.xstream.fromXML((InputStream)in));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save(ChangelogSet changeLogSet, File changelogFile) throws FileNotFoundException {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(changelogFile);
                this.xstream.toXML((Object)changeLogSet, (OutputStream)out);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

