/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesystem_scm;

import hudson.model.User;
import hudson.plugins.filesystem_scm.ChangelogSet;
import hudson.plugins.filesystem_scm.FolderDiff;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.CheckForNull;

public class Changelog
extends ChangeLogSet.Entry {
    private ChangelogSet parent;
    private Date date;
    private List<Path> paths;

    public Changelog() {
    }

    public Changelog(ChangelogSet parent) {
        this.parent = parent;
    }

    public Changelog(ChangelogSet parent, List<FolderDiff.Entry> changes) {
        this.parent = parent;
        this.paths = new ArrayList<Path>();
        for (int i = 0; i < changes.size(); ++i) {
            FolderDiff.Entry change = changes.get(i);
            Path path = new Path(this, change);
            this.paths.add(path);
        }
    }

    public Collection<String> getAffectedPaths() {
        ArrayList<String> list = new ArrayList<String>();
        for (Path path : this.paths) {
            list.add(path.getValue());
        }
        return Collections.unmodifiableList(list);
    }

    public Collection<Path> getAffectedFiles() {
        return Collections.unmodifiableList(this.paths);
    }

    public String getMsg() {
        if (0 == this.paths.size()) {
            return "No change";
        }
        int add = 0;
        int del = 0;
        int edit = 0;
        for (int i = 0; i < this.paths.size(); ++i) {
            Path path = this.paths.get(i);
            if ("ADD".equalsIgnoreCase(path.action)) {
                ++add;
                continue;
            }
            if ("DELETE".equalsIgnoreCase(path.action)) {
                ++del;
                continue;
            }
            ++edit;
        }
        StringBuilder buf = new StringBuilder();
        this.buildMessage(buf, add, "new file", "new files");
        this.buildMessage(buf, edit, "file modified", "files modified");
        this.buildMessage(buf, del, "file deleted", "files deleted");
        return buf.toString();
    }

    private void buildMessage(StringBuilder buf, int count, String singular, String plural) {
        if (count > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(count).append(' ');
            if (count > 1) {
                buf.append(plural);
            } else {
                buf.append(singular);
            }
        }
    }

    public User getAuthor() {
        return User.getUnknown();
    }

    public ChangeLogSet<Changelog> getParent() {
        return this.parent;
    }

    protected void setParent(ChangeLogSet parent) {
        this.parent = (ChangelogSet)parent;
    }

    @CheckForNull
    public Date getDate() {
        return this.date != null ? (Date)this.date.clone() : null;
    }

    public void setDate(Date date) {
        this.date = date != null ? (Date)date.clone() : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.paths == null ? 0 : this.paths.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Changelog other = (Changelog)((Object)obj);
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        return !(this.paths == null ? other.paths != null : !this.paths.equals(other.paths));
    }

    public static class Path
    implements ChangeLogSet.AffectedFile {
        private String value;
        private String action;
        private Changelog changelog;

        public Path() {
        }

        public Path(Changelog changelog) {
            this.changelog = changelog;
        }

        public Path(Changelog changelog, FolderDiff.Entry entry) {
            this.changelog = changelog;
            this.setValue(entry.getFilename());
            if (FolderDiff.Entry.Type.NEW == entry.getType()) {
                this.setAction("ADD");
            } else if (FolderDiff.Entry.Type.DELETED == entry.getType()) {
                this.setAction("DELETE");
            } else {
                this.setAction("EDIT");
            }
        }

        public String getPath() {
            return this.getValue();
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public Changelog getChangelog() {
            return this.changelog;
        }

        protected void setChangelog(Changelog changelog) {
            this.changelog = changelog;
        }

        public EditType getEditType() {
            if ("ADD".equalsIgnoreCase(this.action)) {
                return EditType.ADD;
            }
            if ("DELETE".equalsIgnoreCase(this.action)) {
                return EditType.DELETE;
            }
            return EditType.EDIT;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Path other = (Path)obj;
            if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

