/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesystem_scm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class AllowDeleteList {
    private static final String ALLOW_DELETE_LIST_BASENAME = "fsscm_allow_delete_list.dat";
    private File file;
    private Set<String> set;

    public AllowDeleteList(File projectPath) {
        this.file = new File(projectPath, ALLOW_DELETE_LIST_BASENAME);
        this.set = new HashSet<String>();
    }

    public boolean fileExists() {
        return this.file.exists();
    }

    public Set<String> getList() {
        return Collections.unmodifiableSet(this.set);
    }

    public void setList(Set<String> list) {
        this.set.clear();
        this.set.addAll(list);
    }

    public boolean add(String item) {
        return this.set.add(item);
    }

    public boolean remove(String item) {
        return this.set.remove(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        PrintStream out = null;
        try {
            out = new PrintStream(this.file, "UTF-8");
            for (String name : this.set) {
                out.println(name);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public void load() throws IOException {
        this.set.clear();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
            while (reader.ready()) {
                String line = reader.readLine();
                if (null == line || line.length() <= 0) continue;
                this.set.add(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }
}

