/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.extratoolinstallers.installers;

import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.utils.ExtraToolInstallersException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.InstallSourceProperty;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.FormValidation;
import io.jenkins.plugins.extratoolinstallers.installers.Messages;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class AnyOfInstaller
extends ToolInstaller {
    @CheckForNull
    private InstallSourceProperty installers;
    private int attemptsPerInstaller;
    private int attemptsOfWholeList;

    @DataBoundConstructor
    public AnyOfInstaller() {
        super(null);
    }

    @CheckForNull
    public InstallSourceProperty getInstallers() {
        return this.installers;
    }

    @DataBoundSetter
    public void setInstallers(@Nullable InstallSourceProperty installers) {
        this.installers = installers;
        if (this.tool != null) {
            installers.setTool(this.tool);
        }
    }

    public int getAttemptsPerInstaller() {
        return Math.max(1, this.attemptsPerInstaller);
    }

    @DataBoundSetter
    public void setAttemptsPerInstaller(int attemptsPerInstaller) {
        this.attemptsPerInstaller = attemptsPerInstaller;
    }

    public int getAttemptsOfWholeList() {
        return Math.max(1, this.attemptsOfWholeList);
    }

    @DataBoundSetter
    public void setAttemptsOfWholeList(int attemptsOfWholeList) {
        this.attemptsOfWholeList = attemptsOfWholeList;
    }

    protected void setTool(ToolInstallation t) {
        super.setTool(t);
        if (this.installers != null) {
            this.installers.setTool(t);
        }
    }

    public boolean appliesTo(Node node) {
        List<? extends ToolInstaller> ourInstallers = this.getOurInstallers();
        for (ToolInstaller toolInstaller : ourInstallers) {
            if (!toolInstaller.appliesTo(node)) continue;
            return true;
        }
        return false;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        List<? extends ToolInstaller> allDefinedInstallers = this.getOurInstallers();
        int numberOfConfiguredInstallers = allDefinedInstallers.size();
        Map<Integer, ToolInstaller> allApplicableInstallersByIndex = AnyOfInstaller.calcInstallersThatApplyToNode(node, allDefinedInstallers);
        Map<Integer, String> allApplicableInstallerNamesByIndex = AnyOfInstaller.calcInstallerDisplayNames(allApplicableInstallersByIndex);
        int maxWholeListAttempts = this.getAttemptsOfWholeList();
        int maxAttemptsPerInstaller = this.getAttemptsPerInstaller();
        Exception lastExceptionEncountered = null;
        for (int wholeListAttempt = 1; wholeListAttempt <= maxWholeListAttempts; ++wholeListAttempt) {
            for (Map.Entry<Integer, ToolInstaller> entry : allApplicableInstallersByIndex.entrySet()) {
                ToolInstaller installer = entry.getValue();
                Integer indexOfConfiguredInstaller = entry.getKey();
                for (int installerAttempt = 1; installerAttempt <= maxAttemptsPerInstaller; ++installerAttempt) {
                    try {
                        FilePath result = installer.performInstallation(tool, node, log);
                        return result;
                    }
                    catch (IOException | RuntimeException ex) {
                        lastExceptionEncountered = ex;
                        String displayNameOfThisInstaller = allApplicableInstallerNamesByIndex.get(indexOfConfiguredInstaller);
                        String whatToReport = ex.toString();
                        AnyOfInstaller.logAttempt(log, whatToReport, wholeListAttempt, maxWholeListAttempts, numberOfConfiguredInstallers, indexOfConfiguredInstaller, displayNameOfThisInstaller, maxAttemptsPerInstaller, installerAttempt);
                        continue;
                    }
                }
            }
        }
        throw new ExtraToolInstallersException(this, Messages.AnyOfInstaller_all_failed(), lastExceptionEncountered);
    }

    @NonNull
    private List<? extends ToolInstaller> getOurInstallers() {
        if (this.installers == null || this.installers.installers == null) {
            return Collections.emptyList();
        }
        return this.installers.installers.getAll(ToolInstaller.class);
    }

    private static Map<Integer, ToolInstaller> calcInstallersThatApplyToNode(Node node, List<? extends ToolInstaller> installers) {
        LinkedHashMap<Integer, ToolInstaller> allApplicableInstallersByIndex = new LinkedHashMap<Integer, ToolInstaller>(installers.size());
        int index = 0;
        for (ToolInstaller toolInstaller : installers) {
            ++index;
            if (!toolInstaller.appliesTo(node)) continue;
            allApplicableInstallersByIndex.put(index, toolInstaller);
        }
        return allApplicableInstallersByIndex;
    }

    private static <K> Map<K, String> calcInstallerDisplayNames(Map<K, ToolInstaller> installersByIndex) {
        IdentityHashMap<K, String> installerNamesByIndex = new IdentityHashMap<K, String>(installersByIndex.size());
        for (Map.Entry<K, ToolInstaller> entry : installersByIndex.entrySet()) {
            ToolInstaller installer = entry.getValue();
            K index = entry.getKey();
            String installerName = installer.getDescriptor().getDisplayName();
            installerNamesByIndex.put(index, installerName);
        }
        return installerNamesByIndex;
    }

    private static void logAttempt(TaskListener log, String whatToReport, int wholeListAttempt, int maxWholeListAttempts, int numberOfConfiguredOfInstallers, Integer indexOfConfiguredInstaller, String nameOfConfiguredInstaller, int maxAttemptsPerInstaller, int installerAttempt) {
        String msg = maxWholeListAttempts > 1 ? (numberOfConfiguredOfInstallers > 1 ? (maxAttemptsPerInstaller > 1 ? Messages.AnyOfInstaller_loops_installers_attempts(wholeListAttempt, maxWholeListAttempts, indexOfConfiguredInstaller, numberOfConfiguredOfInstallers, nameOfConfiguredInstaller, installerAttempt, maxAttemptsPerInstaller, whatToReport) : Messages.AnyOfInstaller_loops_installers_1attempt(wholeListAttempt, maxWholeListAttempts, indexOfConfiguredInstaller, numberOfConfiguredOfInstallers, nameOfConfiguredInstaller, installerAttempt, maxAttemptsPerInstaller, whatToReport)) : (maxAttemptsPerInstaller > 1 ? Messages.AnyOfInstaller_loops_1installer_attempts(wholeListAttempt, maxWholeListAttempts, indexOfConfiguredInstaller, numberOfConfiguredOfInstallers, nameOfConfiguredInstaller, installerAttempt, maxAttemptsPerInstaller, whatToReport) : Messages.AnyOfInstaller_loops_1installer_1attempt(wholeListAttempt, maxWholeListAttempts, indexOfConfiguredInstaller, numberOfConfiguredOfInstallers, nameOfConfiguredInstaller, installerAttempt, maxAttemptsPerInstaller, whatToReport))) : (numberOfConfiguredOfInstallers > 1 ? (maxAttemptsPerInstaller > 1 ? Messages.AnyOfInstaller_1loop_installers_attempts(wholeListAttempt, maxWholeListAttempts, indexOfConfiguredInstaller, numberOfConfiguredOfInstallers, nameOfConfiguredInstaller, installerAttempt, maxAttemptsPerInstaller, whatToReport) : Messages.AnyOfInstaller_1loop_installers_1attempt(wholeListAttempt, maxWholeListAttempts, indexOfConfiguredInstaller, numberOfConfiguredOfInstallers, nameOfConfiguredInstaller, installerAttempt, maxAttemptsPerInstaller, whatToReport)) : (maxAttemptsPerInstaller > 1 ? Messages.AnyOfInstaller_1loop_1installer_attempts(wholeListAttempt, maxWholeListAttempts, indexOfConfiguredInstaller, numberOfConfiguredOfInstallers, nameOfConfiguredInstaller, installerAttempt, maxAttemptsPerInstaller, whatToReport) : Messages.AnyOfInstaller_1loop_1installer_1attempt(wholeListAttempt, maxWholeListAttempts, indexOfConfiguredInstaller, numberOfConfiguredOfInstallers, nameOfConfiguredInstaller, installerAttempt, maxAttemptsPerInstaller, whatToReport)));
        PrintStream output = log.getLogger();
        output.println(msg);
    }

    @Extension
    @Symbol(value={"anyOf"})
    public static class DescriptorImpl
    extends ToolInstallerDescriptor<AnyOfInstaller> {
        public String getDisplayName() {
            return Messages.AnyOfInstaller_DescriptorImpl_displayName();
        }

        public FormValidation doCheckAttemptsPerInstaller(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }

        public FormValidation doCheckAttemptsOfWholeList(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }
    }
}

