/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.DateTimeUnit;
import com.github.tomakehurst.wiremock.matching.AbstractDateTimeMatchResult;
import com.github.tomakehurst.wiremock.matching.AbstractDateTimePattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public class BeforeDateTimePattern
extends AbstractDateTimePattern {
    public BeforeDateTimePattern(ZonedDateTime zonedDateTime) {
        super(zonedDateTime);
    }

    public BeforeDateTimePattern(LocalDateTime localDateTime) {
        super(localDateTime);
    }

    public BeforeDateTimePattern(String dateTimeSpec) {
        super(dateTimeSpec);
    }

    public BeforeDateTimePattern(@JsonProperty(value="before") String dateTimeSpec, @JsonProperty(value="actualFormat") String actualDateFormat, @JsonProperty(value="truncateExpected") String truncateExpected, @JsonProperty(value="truncateActual") String truncateActual, @JsonProperty(value="applyTruncationLast") boolean applyTruncationLast, @JsonProperty(value="expectedOffset") Integer expectedOffsetAmount, @JsonProperty(value="expectedOffsetUnit") DateTimeUnit expectedOffsetUnit) {
        super(dateTimeSpec, actualDateFormat, truncateExpected, truncateActual, applyTruncationLast, expectedOffsetAmount, expectedOffsetUnit);
    }

    @Override
    protected MatchResult getMatchResult(ZonedDateTime zonedExpected, LocalDateTime localExpected, ZonedDateTime zonedActual, LocalDateTime localActual) {
        return new AbstractDateTimeMatchResult(zonedExpected, localExpected, zonedActual, localActual){

            @Override
            protected boolean matchZonedZoned() {
                return this.zonedActual.isBefore(this.zonedExpected);
            }

            @Override
            protected boolean matchLocalLocal() {
                return this.localActual.isBefore(this.localExpected);
            }

            @Override
            protected boolean matchLocalZoned() {
                return this.zonedActual.toLocalDateTime().isBefore(this.localExpected);
            }

            @Override
            protected boolean matchZonedLocal() {
                return this.localActual.atZone(ZoneId.systemDefault()).isBefore(this.zonedExpected);
            }
        };
    }

    public String getBefore() {
        return this.getValue();
    }
}

