/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Exclusion
extends AbstractDescribableImpl<Exclusion> {
    public static final Logger LOGGER = Logger.getLogger(Exclusion.class.getName());
    private final String fqcn;
    private String context;

    @DataBoundConstructor
    public Exclusion(String fqcn, String context) {
        this.fqcn = fqcn;
        this.context = Util.fixEmpty((String)context);
    }

    public String getFqcn() {
        return this.fqcn;
    }

    public String getContext() {
        return this.context;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Exclusion> {
        public String getDisplayName() {
            return "Extension";
        }

        public FormValidation doCheckFqcn(@QueryParameter String fqcn) {
            Class<?> definedClass;
            try {
                definedClass = Jenkins.get().pluginManager.uberClassLoader.loadClass(fqcn);
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.WARNING, "Failed to load class " + fqcn);
                return FormValidation.error((String)Messages.Exclusion_classNotFoundMsg());
            }
            boolean isExtension = ExtensionPoint.class.isAssignableFrom(definedClass);
            boolean isDescriptor = Descriptor.class.isAssignableFrom(definedClass);
            if (isExtension && isDescriptor) {
                return FormValidation.ok((String)Messages.Exclusion_classIsExtensionAndDescriptor());
            }
            if (isExtension) {
                return FormValidation.ok((String)Messages.Exclusion_classIsExtension());
            }
            if (isDescriptor) {
                return FormValidation.ok((String)Messages.Exclusion_classIsDescriptor());
            }
            return FormValidation.error((String)Messages.Exclusion_unsupportedType());
        }
    }
}

