/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.extensible_choice_parameter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.StringParameterValue;
import java.util.List;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ExtensibleChoiceParameterDefinition;

@Extension
public class ChoiceWatchQueueDecisionHandler
extends Queue.QueueDecisionHandler {
    public boolean shouldSchedule(Queue.Task p, List<Action> actions) {
        this.onQueueing(p, actions);
        return true;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="TODO needs triage")
    protected void onQueueing(Queue.Task p, List<Action> actions) {
        if (!(p instanceof AbstractProject)) {
            return;
        }
        AbstractProject job = (AbstractProject)p;
        ParametersDefinitionProperty pp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        if (pp == null) {
            return;
        }
        for (ParametersAction action : Util.filter(actions, ParametersAction.class)) {
            for (StringParameterValue value : Util.filter((List)action.getParameters(), StringParameterValue.class)) {
                ExtensibleChoiceParameterDefinition choiceDef;
                ParameterDefinition def = pp.getParameterDefinition(value.getName());
                if (def == null || !(def instanceof ExtensibleChoiceParameterDefinition) || (choiceDef = (ExtensibleChoiceParameterDefinition)def).getChoiceListProvider() == null) continue;
                choiceDef.getChoiceListProvider().onBuildTriggeredWithValue(job, choiceDef, value.getValue().toString());
            }
        }
    }
}

