/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.googleai.GeminiContent;
import dev.langchain4j.model.googleai.GeminiFunctionDeclaration;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.Json;
import dev.langchain4j.model.googleai.SchemaMapper;
import java.util.List;
import java.util.Objects;

class FunctionMapper {
    FunctionMapper() {
    }

    static GeminiGenerateContentRequest.GeminiTool fromToolSepcsToGTool(List<ToolSpecification> specifications, boolean allowCodeExecution) {
        if (Utils.isNullOrEmpty(specifications)) {
            if (allowCodeExecution) {
                return new GeminiGenerateContentRequest.GeminiTool(null, new GeminiGenerateContentRequest.GeminiTool.GeminiCodeExecution());
            }
            return null;
        }
        List<GeminiFunctionDeclaration> functionDeclarations = specifications.stream().map(specification -> {
            GeminiFunctionDeclaration.Builder fnBuilder = GeminiFunctionDeclaration.builder().name(specification.name());
            if (specification.description() != null) {
                fnBuilder.description(specification.description());
            }
            if (specification.parameters() != null) {
                fnBuilder.parameters(SchemaMapper.fromJsonSchemaToGSchema((JsonSchemaElement)specification.parameters()));
            }
            return fnBuilder.build();
        }).filter(Objects::nonNull).toList();
        return new GeminiGenerateContentRequest.GeminiTool(functionDeclarations.isEmpty() ? null : functionDeclarations, allowCodeExecution ? new GeminiGenerateContentRequest.GeminiTool.GeminiCodeExecution() : null);
    }

    static List<ToolExecutionRequest> toToolExecutionRequests(List<GeminiContent.GeminiPart.GeminiFunctionCall> functionCalls) {
        return functionCalls.stream().map(functionCall -> ToolExecutionRequest.builder().name(functionCall.name()).arguments(Json.toJsonWithoutIndent(functionCall.args())).build()).toList();
    }
}

