/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import hudson.model.Run;
import java.text.SimpleDateFormat;
import java.util.Date;
import jenkins.model.RunAction2;

public class ErrorExplanationAction
implements RunAction2 {
    private final String explanation;
    private final transient String originalErrorLogs;
    private final long timestamp;
    private String providerName = "Unknown";
    private transient Run<?, ?> run;

    public ErrorExplanationAction(String explanation, String originalErrorLogs, String providerName) {
        this.explanation = explanation;
        this.originalErrorLogs = originalErrorLogs;
        this.timestamp = System.currentTimeMillis();
        this.providerName = providerName;
    }

    public Object readResolve() {
        if (this.providerName == null) {
            this.providerName = "Unknown";
        }
        return this;
    }

    public String getIconFileName() {
        return "symbol-cube";
    }

    public String getDisplayName() {
        return "AI Error Explanation";
    }

    public String getUrlName() {
        return "error-explanation";
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getOriginalErrorLogs() {
        return this.originalErrorLogs;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getFormattedTimestamp() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.timestamp));
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void onAttached(Run<?, ?> r) {
        this.run = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.run = r;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public boolean hasValidExplanation() {
        return this.explanation != null && !this.explanation.isBlank();
    }
}

