/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ReturnBehavior;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.ToolArgumentsException;
import dev.langchain4j.internal.DefaultExecutorProvider;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.invocation.InvocationContext;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.observability.api.AiServiceListenerRegistrar;
import dev.langchain4j.observability.api.event.AiServiceEvent;
import dev.langchain4j.observability.api.event.AiServiceResponseReceivedEvent;
import dev.langchain4j.observability.api.event.ToolExecutedEvent;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.tool.DefaultToolExecutor;
import dev.langchain4j.service.tool.HallucinatedToolNameStrategy;
import dev.langchain4j.service.tool.ToolArgumentsErrorHandler;
import dev.langchain4j.service.tool.ToolErrorContext;
import dev.langchain4j.service.tool.ToolErrorHandlerResult;
import dev.langchain4j.service.tool.ToolExecution;
import dev.langchain4j.service.tool.ToolExecutionErrorHandler;
import dev.langchain4j.service.tool.ToolExecutionResult;
import dev.langchain4j.service.tool.ToolExecutor;
import dev.langchain4j.service.tool.ToolProvider;
import dev.langchain4j.service.tool.ToolProviderRequest;
import dev.langchain4j.service.tool.ToolProviderResult;
import dev.langchain4j.service.tool.ToolServiceContext;
import dev.langchain4j.service.tool.ToolServiceResult;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;

@Internal
public class ToolService {
    private static final ToolArgumentsErrorHandler DEFAULT_TOOL_ARGUMENTS_ERROR_HANDLER = (error, context) -> {
        if (error instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)error;
            throw re;
        }
        throw new RuntimeException(error);
    };
    private static final ToolExecutionErrorHandler DEFAULT_TOOL_EXECUTION_ERROR_HANDLER = (error, context) -> {
        String errorMessage = Utils.isNullOrBlank((String)error.getMessage()) ? error.getClass().getName() : error.getMessage();
        return ToolErrorHandlerResult.text(errorMessage);
    };
    private final List<ToolSpecification> toolSpecifications = new ArrayList<ToolSpecification>();
    private final Map<String, ToolExecutor> toolExecutors = new HashMap<String, ToolExecutor>();
    private final Set<String> immediateReturnTools = new HashSet<String>();
    private ToolProvider toolProvider;
    private Executor executor;
    private int maxSequentialToolsInvocations = 100;
    private ToolArgumentsErrorHandler argumentsErrorHandler;
    private ToolExecutionErrorHandler executionErrorHandler;
    private Function<ToolExecutionRequest, ToolExecutionResultMessage> toolHallucinationStrategy = HallucinatedToolNameStrategy.THROW_EXCEPTION;

    public void hallucinatedToolNameStrategy(Function<ToolExecutionRequest, ToolExecutionResultMessage> toolHallucinationStrategy) {
        this.toolHallucinationStrategy = toolHallucinationStrategy;
    }

    public void toolProvider(ToolProvider toolProvider) {
        this.toolProvider = toolProvider;
    }

    public void tools(Map<ToolSpecification, ToolExecutor> tools) {
        tools.forEach((toolSpecification, toolExecutor) -> {
            this.toolSpecifications.add((ToolSpecification)toolSpecification);
            this.toolExecutors.put(toolSpecification.name(), (ToolExecutor)toolExecutor);
        });
    }

    public void tools(Map<ToolSpecification, ToolExecutor> tools, Set<String> immediateReturnToolNames) {
        this.tools(tools);
        this.immediateReturnTools.addAll(immediateReturnToolNames);
    }

    public void tools(Collection<Object> objectsWithTools) {
        for (Object objectWithTool : objectsWithTools) {
            if (objectWithTool instanceof Class) {
                throw IllegalConfigurationException.illegalConfiguration("Tool '%s' must be an object, not a class", objectWithTool);
            }
            for (Method method : objectWithTool.getClass().getDeclaredMethods()) {
                Utils.getAnnotatedMethod((Method)method, Tool.class).ifPresent(toolMethod -> this.processToolMethod(objectWithTool, (Method)toolMethod));
            }
        }
    }

    private void processToolMethod(Object object, Method method) {
        ToolSpecification toolSpecification = ToolSpecifications.toolSpecificationFrom((Method)method);
        if (this.toolExecutors.containsKey(toolSpecification.name())) {
            throw new IllegalConfigurationException("Duplicated definition for tool: " + toolSpecification.name());
        }
        this.toolSpecifications.add(toolSpecification);
        ToolExecutor toolExecutor = ToolService.createToolExecutor(object, method);
        this.toolExecutors.put(toolSpecification.name(), toolExecutor);
        if (method.getAnnotation(Tool.class).returnBehavior() == ReturnBehavior.IMMEDIATE) {
            this.immediateReturnTools.add(toolSpecification.name());
        }
    }

    private static ToolExecutor createToolExecutor(Object object, Method method) {
        return DefaultToolExecutor.builder().object(object).originalMethod(method).methodToInvoke(method).wrapToolArgumentsExceptions(true).propagateToolExecutionExceptions(true).build();
    }

    public void executeToolsConcurrently() {
        this.executor = ToolService.defaultExecutor();
    }

    public void executeToolsConcurrently(Executor executor) {
        this.executor = (Executor)Utils.getOrDefault((Object)executor, ToolService::defaultExecutor);
    }

    private static Executor defaultExecutor() {
        return DefaultExecutorProvider.getDefaultExecutorService();
    }

    public void maxSequentialToolsInvocations(int maxSequentialToolsInvocations) {
        this.maxSequentialToolsInvocations = maxSequentialToolsInvocations;
    }

    public void argumentsErrorHandler(ToolArgumentsErrorHandler handler) {
        this.argumentsErrorHandler = handler;
    }

    public ToolArgumentsErrorHandler argumentsErrorHandler() {
        return (ToolArgumentsErrorHandler)Utils.getOrDefault((Object)this.argumentsErrorHandler, (Object)DEFAULT_TOOL_ARGUMENTS_ERROR_HANDLER);
    }

    public void executionErrorHandler(ToolExecutionErrorHandler handler) {
        this.executionErrorHandler = handler;
    }

    public ToolExecutionErrorHandler executionErrorHandler() {
        return (ToolExecutionErrorHandler)Utils.getOrDefault((Object)this.executionErrorHandler, (Object)DEFAULT_TOOL_EXECUTION_ERROR_HANDLER);
    }

    public ToolServiceContext createContext(InvocationContext invocationContext, UserMessage userMessage) {
        if (this.toolProvider == null) {
            return this.toolSpecifications.isEmpty() ? ToolServiceContext.Empty.INSTANCE : new ToolServiceContext(this.toolSpecifications, this.toolExecutors);
        }
        ArrayList<ToolSpecification> toolsSpecs = new ArrayList<ToolSpecification>(this.toolSpecifications);
        HashMap<String, ToolExecutor> toolExecs = new HashMap<String, ToolExecutor>(this.toolExecutors);
        ToolProviderRequest toolProviderRequest = ToolProviderRequest.builder().invocationContext(invocationContext).userMessage(userMessage).build();
        ToolProviderResult toolProviderResult = this.toolProvider.provideTools(toolProviderRequest);
        if (toolProviderResult != null) {
            for (Map.Entry<ToolSpecification, ToolExecutor> entry : toolProviderResult.tools().entrySet()) {
                if (toolExecs.putIfAbsent(entry.getKey().name(), entry.getValue()) == null) {
                    toolsSpecs.add(entry.getKey());
                    continue;
                }
                throw new IllegalConfigurationException("Duplicated definition for tool: " + entry.getKey().name());
            }
        }
        return new ToolServiceContext(toolsSpecs, toolExecs);
    }

    public ToolServiceResult executeInferenceAndToolsLoop(AiServiceContext context, Object memoryId, ChatResponse chatResponse, ChatRequestParameters parameters, List<ChatMessage> messages, ChatMemory chatMemory, InvocationContext invocationContext, Map<String, ToolExecutor> toolExecutors, boolean isReturnTypeResult) {
        TokenUsage aggregateTokenUsage = chatResponse.metadata().tokenUsage();
        ArrayList<ToolExecution> toolExecutions = new ArrayList<ToolExecution>();
        ArrayList<ChatResponse> intermediateResponses = new ArrayList<ChatResponse>();
        int executionsLeft = this.maxSequentialToolsInvocations;
        while (true) {
            if (executionsLeft-- == 0) {
                throw Exceptions.runtime((String)"Something is wrong, exceeded %s sequential tool executions", (Object[])new Object[]{this.maxSequentialToolsInvocations});
            }
            AiMessage aiMessage = chatResponse.aiMessage();
            if (chatMemory != null) {
                chatMemory.add((ChatMessage)aiMessage);
            } else {
                messages = new ArrayList<ChatMessage>(messages);
                messages.add((ChatMessage)aiMessage);
            }
            if (!aiMessage.hasToolExecutionRequests()) break;
            intermediateResponses.add(chatResponse);
            Map<ToolExecutionRequest, ToolExecutionResult> toolResults = this.execute(aiMessage.toolExecutionRequests(), toolExecutors, invocationContext);
            boolean immediateToolReturn = true;
            for (Map.Entry<ToolExecutionRequest, ToolExecutionResult> entry : toolResults.entrySet()) {
                ToolExecutionRequest request = entry.getKey();
                ToolExecutionResult result = entry.getValue();
                ToolExecutionResultMessage resultMessage = ToolExecutionResultMessage.from((ToolExecutionRequest)request, (String)result.resultText());
                ToolExecution toolExecution = ToolExecution.builder().request(request).result(result).build();
                toolExecutions.add(toolExecution);
                context.eventListenerRegistrar.fireEvent((AiServiceEvent)ToolExecutedEvent.builder().invocationContext(invocationContext).request(request).resultText(toolExecution.result()).build());
                if (chatMemory != null) {
                    chatMemory.add((ChatMessage)resultMessage);
                } else {
                    messages.add(resultMessage);
                }
                if (!immediateToolReturn) continue;
                if (this.isImmediateTool(request.name())) {
                    if (isReturnTypeResult) continue;
                    throw IllegalConfigurationException.illegalConfiguration("Tool '%s' with immediate return is not allowed on a AI service not returning Result.", request.name());
                }
                immediateToolReturn = false;
            }
            if (immediateToolReturn) {
                ChatResponse finalResponse = (ChatResponse)intermediateResponses.remove(intermediateResponses.size() - 1);
                return ToolServiceResult.builder().intermediateResponses(intermediateResponses).finalResponse(finalResponse).toolExecutions(toolExecutions).aggregateTokenUsage(aggregateTokenUsage).immediateToolReturn(true).build();
            }
            if (chatMemory != null) {
                messages = chatMemory.messages();
            }
            ChatRequest chatRequest = context.chatRequestTransformer.apply(ChatRequest.builder().messages(messages).parameters(parameters).build(), memoryId);
            chatResponse = context.chatModel.chat(chatRequest);
            this.fireResponseReceivedEvent(chatResponse, invocationContext, context.eventListenerRegistrar);
            aggregateTokenUsage = TokenUsage.sum((TokenUsage)aggregateTokenUsage, (TokenUsage)chatResponse.metadata().tokenUsage());
        }
        return ToolServiceResult.builder().intermediateResponses(intermediateResponses).finalResponse(chatResponse).toolExecutions(toolExecutions).aggregateTokenUsage(aggregateTokenUsage).build();
    }

    private void fireResponseReceivedEvent(ChatResponse chatResponse, InvocationContext invocationContext, AiServiceListenerRegistrar listenerRegistrar) {
        listenerRegistrar.fireEvent((AiServiceEvent)AiServiceResponseReceivedEvent.builder().invocationContext(invocationContext).response(chatResponse).build());
    }

    private Map<ToolExecutionRequest, ToolExecutionResult> execute(List<ToolExecutionRequest> toolRequests, Map<String, ToolExecutor> toolExecutors, InvocationContext invocationContext) {
        if (this.executor != null && toolRequests.size() > 1) {
            return this.executeConcurrently(toolRequests, toolExecutors, invocationContext);
        }
        return this.executeSequentially(toolRequests, toolExecutors, invocationContext);
    }

    private Map<ToolExecutionRequest, ToolExecutionResult> executeConcurrently(List<ToolExecutionRequest> toolRequests, Map<String, ToolExecutor> toolExecutors, InvocationContext invocationContext) {
        LinkedHashMap<ToolExecutionRequest, CompletableFuture<ToolExecutionResult>> futures = new LinkedHashMap<ToolExecutionRequest, CompletableFuture<ToolExecutionResult>>();
        for (ToolExecutionRequest toolRequest : toolRequests) {
            CompletableFuture<ToolExecutionResult> future = CompletableFuture.supplyAsync(() -> {
                ToolExecutor toolExecutor = (ToolExecutor)toolExecutors.get(toolRequest.name());
                if (toolExecutor == null) {
                    return this.applyToolHallucinationStrategy(toolRequest);
                }
                return ToolService.executeWithErrorHandling(toolRequest, toolExecutor, invocationContext, this.argumentsErrorHandler(), this.executionErrorHandler());
            }, this.executor);
            futures.put(toolRequest, future);
        }
        LinkedHashMap<ToolExecutionRequest, ToolExecutionResult> results = new LinkedHashMap<ToolExecutionRequest, ToolExecutionResult>();
        for (Map.Entry entry : futures.entrySet()) {
            try {
                results.put((ToolExecutionRequest)entry.getKey(), (ToolExecutionResult)((CompletableFuture)entry.getValue()).get());
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)throwable;
                    throw re;
                }
                throw new RuntimeException(e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        return results;
    }

    private Map<ToolExecutionRequest, ToolExecutionResult> executeSequentially(List<ToolExecutionRequest> toolRequests, Map<String, ToolExecutor> toolExecutors, InvocationContext invocationContext) {
        LinkedHashMap<ToolExecutionRequest, ToolExecutionResult> toolResults = new LinkedHashMap<ToolExecutionRequest, ToolExecutionResult>();
        for (ToolExecutionRequest toolRequest : toolRequests) {
            ToolExecutor executor = toolExecutors.get(toolRequest.name());
            ToolExecutionResult toolResult = executor == null ? this.applyToolHallucinationStrategy(toolRequest) : ToolService.executeWithErrorHandling(toolRequest, executor, invocationContext, this.argumentsErrorHandler(), this.executionErrorHandler());
            toolResults.put(toolRequest, toolResult);
        }
        return toolResults;
    }

    public static ToolExecutionResult executeWithErrorHandling(ToolExecutionRequest toolRequest, ToolExecutor toolExecutor, InvocationContext invocationContext, ToolArgumentsErrorHandler argumentsErrorHandler, ToolExecutionErrorHandler executionErrorHandler) {
        try {
            return toolExecutor.executeWithContext(toolRequest, invocationContext);
        }
        catch (Exception e) {
            ToolErrorContext errorContext = ToolErrorContext.builder().toolExecutionRequest(toolRequest).invocationContext(invocationContext).build();
            ToolErrorHandlerResult errorHandlerResult = e instanceof ToolArgumentsException ? argumentsErrorHandler.handle(ToolService.getCause(e), errorContext) : executionErrorHandler.handle(ToolService.getCause(e), errorContext);
            return ToolExecutionResult.builder().isError(true).resultText(errorHandlerResult.text()).build();
        }
    }

    private static Throwable getCause(Exception e) {
        Throwable cause = e.getCause();
        return cause != null ? cause : e;
    }

    public ToolExecutionResult applyToolHallucinationStrategy(ToolExecutionRequest toolRequest) {
        ToolExecutionResultMessage toolResultMessage = this.toolHallucinationStrategy.apply(toolRequest);
        return ToolExecutionResult.builder().resultText(toolResultMessage.text()).build();
    }

    public List<ToolSpecification> toolSpecifications() {
        return this.toolSpecifications;
    }

    public Map<String, ToolExecutor> toolExecutors() {
        return this.toolExecutors;
    }

    public Executor executor() {
        return this.executor;
    }

    public ToolProvider toolProvider() {
        return this.toolProvider;
    }

    public boolean isImmediateTool(String toolName) {
        return this.immediateReturnTools.contains(toolName);
    }
}

