/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.guardrail;

import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.guardrail.AbstractGuardrailExecutor;
import dev.langchain4j.guardrail.GuardrailResult;
import dev.langchain4j.guardrail.OutputGuardrail;
import dev.langchain4j.guardrail.OutputGuardrailException;
import dev.langchain4j.guardrail.OutputGuardrailRequest;
import dev.langchain4j.guardrail.OutputGuardrailResult;
import dev.langchain4j.guardrail.config.OutputGuardrailsConfig;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.spi.guardrail.GuardrailExecutorBuilderFactory;
import dev.langchain4j.spi.guardrail.OutputGuardrailExecutorBuilderFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public class OutputGuardrailExecutor
extends AbstractGuardrailExecutor<OutputGuardrailsConfig, OutputGuardrailRequest, OutputGuardrailResult, OutputGuardrail, OutputGuardrailResult.Failure> {
    public static final String MAX_RETRIES_MESSAGE_TEMPLATE = "Output validation failed. The guardrails have reached the maximum number of retries.\nGuardrail messages:\n\n%s\n";

    protected OutputGuardrailExecutor(OutputGuardrailsConfig config, List<OutputGuardrail> guardrails) {
        super(config, guardrails);
    }

    @Override
    public OutputGuardrailResult execute(OutputGuardrailRequest params) {
        OutputGuardrailResult result = null;
        OutputGuardrailRequest accumulatedParams = params;
        int attempt = 0;
        int maxAttempts = ((OutputGuardrailsConfig)this.config()).maxRetries();
        if (maxAttempts == 0) {
            maxAttempts = 1;
        } else if (maxAttempts < 0) {
            maxAttempts = 2;
        }
        while (attempt < maxAttempts) {
            result = (OutputGuardrailResult)this.executeGuardrails(accumulatedParams);
            if (result.isSuccess()) {
                return result;
            }
            if (!result.isRetry()) {
                throw new OutputGuardrailException(result.toString(), result.getFirstFailureException());
            }
            if (++attempt >= maxAttempts) continue;
            List chatMessages = Optional.ofNullable(accumulatedParams.requestParams().chatMemory()).map(ChatMemory::messages).orElseGet(ArrayList::new);
            result.getReprompt().map(UserMessage::from).ifPresent(chatMessages::add);
            ChatResponse response = accumulatedParams.chatExecutor().execute(chatMessages);
            accumulatedParams = OutputGuardrailRequest.builder().responseFromLLM(response).chatExecutor(accumulatedParams.chatExecutor()).requestParams(accumulatedParams.requestParams()).build();
        }
        if (attempt == maxAttempts) {
            String failureMessages = result.failures().stream().map(GuardrailResult.Failure::message).collect(Collectors.joining(System.lineSeparator()));
            throw new OutputGuardrailException(MAX_RETRIES_MESSAGE_TEMPLATE.formatted(failureMessages));
        }
        return result;
    }

    @Override
    protected OutputGuardrailResult createFailure(List<OutputGuardrailResult.Failure> failures) {
        return OutputGuardrailResult.failure(failures);
    }

    @Override
    protected OutputGuardrailResult createSuccess() {
        return OutputGuardrailResult.success();
    }

    @Override
    protected OutputGuardrailException createGuardrailException(String message, Throwable cause) {
        return new OutputGuardrailException(message, cause);
    }

    @Override
    protected OutputGuardrailResult handleFatalResult(OutputGuardrailResult accumulatedResult, OutputGuardrailResult result) {
        return accumulatedResult.hasRewrittenResult() ? result.blockRetry() : result;
    }

    public static OutputGuardrailExecutorBuilder builder() {
        return ServiceLoader.load(OutputGuardrailExecutorBuilderFactory.class).findFirst().map(GuardrailExecutorBuilderFactory::getBuilder).orElseGet(OutputGuardrailExecutorBuilder::new);
    }

    public static class OutputGuardrailExecutorBuilder
    extends AbstractGuardrailExecutor.GuardrailExecutorBuilder<OutputGuardrailsConfig, OutputGuardrailResult, OutputGuardrailRequest, OutputGuardrail, OutputGuardrailExecutorBuilder> {
        protected OutputGuardrailExecutorBuilder() {
            super((OutputGuardrailsConfig)OutputGuardrailsConfig.builder().build());
        }

        public OutputGuardrailExecutor build() {
            return new OutputGuardrailExecutor((OutputGuardrailsConfig)this.config(), this.guardrails());
        }
    }
}

