/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.inmemory;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import dev.langchain4j.Internal;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.inmemory.InMemoryEmbeddingStore;
import dev.langchain4j.store.embedding.inmemory.InMemoryEmbeddingStoreJsonCodec;

@Internal
class JacksonInMemoryEmbeddingStoreJsonCodec
implements InMemoryEmbeddingStoreJsonCodec {
    private static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY)).addMixIn(InMemoryEmbeddingStore.Entry.class, EntryMixIn.class)).addMixIn(Embedding.class, EmbeddingMixIn.class)).addMixIn(TextSegment.class, TextSegmentMixin.class)).build();
    private static final TypeReference<InMemoryEmbeddingStore<TextSegment>> TYPE_REFERENCE = new TypeReference<InMemoryEmbeddingStore<TextSegment>>(){};

    JacksonInMemoryEmbeddingStoreJsonCodec() {
    }

    @Override
    public InMemoryEmbeddingStore<TextSegment> fromJson(String json) {
        try {
            return (InMemoryEmbeddingStore)OBJECT_MAPPER.readValue(json, TYPE_REFERENCE);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toJson(InMemoryEmbeddingStore<?> store) {
        try {
            return OBJECT_MAPPER.writeValueAsString(store);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static abstract class EntryMixIn<T> {
        @JsonCreator
        EntryMixIn(@JsonProperty(value="id") String id, @JsonProperty(value="embedding") Embedding embedding, @JsonProperty(value="embedded") T embedded) {
        }
    }

    private static abstract class EmbeddingMixIn {
        @JsonCreator
        EmbeddingMixIn(@JsonProperty(value="vector") float[] vector) {
        }

        @JsonProperty(value="vector")
        abstract float[] vector();
    }

    private static abstract class TextSegmentMixin {
        @JsonCreator
        public TextSegmentMixin(@JsonProperty(value="text") String text, @JsonProperty(value="metadata") Metadata metadata) {
        }
    }
}

