/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.List;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;

public class SuffixFeatureGenerator
implements AdaptiveFeatureGenerator {
    private static final String PREFIX = "suf=";
    static final int DEFAULT_MAX_LENGTH = 4;
    private final int suffixLength;

    public SuffixFeatureGenerator() {
        this.suffixLength = 4;
    }

    public SuffixFeatureGenerator(int suffixLength) {
        this.suffixLength = suffixLength;
    }

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        String[] suffs;
        for (String suff : suffs = this.getSuffixes(tokens[index])) {
            features.add(PREFIX + suff);
        }
    }

    private String[] getSuffixes(String lex) {
        int suffixes = StrictMath.min(this.suffixLength, lex.length());
        String[] suffs = new String[suffixes];
        for (int li = 0; li < suffixes; ++li) {
            suffs[li] = lex.substring(StrictMath.max(lex.length() - li - 1, 0));
        }
        return suffs;
    }
}

