/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.guardrail.ChatExecutor;
import dev.langchain4j.guardrail.GuardrailRequestParams;
import dev.langchain4j.guardrail.OutputGuardrailRequest;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.CompleteToolCall;
import dev.langchain4j.model.chat.response.PartialThinking;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.tool.BeforeToolExecution;
import dev.langchain4j.service.tool.ToolArgumentsErrorHandler;
import dev.langchain4j.service.tool.ToolExecution;
import dev.langchain4j.service.tool.ToolExecutionErrorHandler;
import dev.langchain4j.service.tool.ToolExecutor;
import dev.langchain4j.service.tool.ToolService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class AiServiceStreamingResponseHandler
implements StreamingChatResponseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AiServiceStreamingResponseHandler.class);
    private final ChatExecutor chatExecutor;
    private final AiServiceContext context;
    private final Object memoryId;
    private final GuardrailRequestParams commonGuardrailParams;
    private final Object methodKey;
    private final Consumer<String> partialResponseHandler;
    private final Consumer<PartialThinking> partialThinkingHandler;
    private final Consumer<BeforeToolExecution> beforeToolExecutionHandler;
    private final Consumer<ToolExecution> toolExecutionHandler;
    private final Consumer<ChatResponse> intermediateResponseHandler;
    private final Consumer<ChatResponse> completeResponseHandler;
    private final Consumer<Throwable> errorHandler;
    private final ChatMemory temporaryMemory;
    private final TokenUsage tokenUsage;
    private final List<ToolSpecification> toolSpecifications;
    private final Map<String, ToolExecutor> toolExecutors;
    private final ToolArgumentsErrorHandler toolArgumentsErrorHandler;
    private final ToolExecutionErrorHandler toolExecutionErrorHandler;
    private final Executor toolExecutor;
    private final Queue<CompletableFuture<ToolExecutionResultMessage>> toolResultFutures = new ConcurrentLinkedQueue<CompletableFuture<ToolExecutionResultMessage>>();
    private final List<String> responseBuffer = new ArrayList<String>();
    private final boolean hasOutputGuardrails;

    AiServiceStreamingResponseHandler(ChatExecutor chatExecutor, AiServiceContext context, Object memoryId, Consumer<String> partialResponseHandler, Consumer<PartialThinking> partialThinkingHandler, Consumer<BeforeToolExecution> beforeToolExecutionHandler, Consumer<ToolExecution> toolExecutionHandler, Consumer<ChatResponse> intermediateResponseHandler, Consumer<ChatResponse> completeResponseHandler, Consumer<Throwable> errorHandler, ChatMemory temporaryMemory, TokenUsage tokenUsage, List<ToolSpecification> toolSpecifications, Map<String, ToolExecutor> toolExecutors, ToolArgumentsErrorHandler toolArgumentsErrorHandler, ToolExecutionErrorHandler toolExecutionErrorHandler, Executor toolExecutor, GuardrailRequestParams commonGuardrailParams, Object methodKey) {
        this.chatExecutor = (ChatExecutor)ValidationUtils.ensureNotNull((Object)chatExecutor, (String)"chatExecutor");
        this.context = (AiServiceContext)ValidationUtils.ensureNotNull((Object)context, (String)"context");
        this.memoryId = ValidationUtils.ensureNotNull((Object)memoryId, (String)"memoryId");
        this.methodKey = methodKey;
        this.partialResponseHandler = (Consumer)ValidationUtils.ensureNotNull(partialResponseHandler, (String)"partialResponseHandler");
        this.partialThinkingHandler = partialThinkingHandler;
        this.intermediateResponseHandler = intermediateResponseHandler;
        this.completeResponseHandler = completeResponseHandler;
        this.beforeToolExecutionHandler = beforeToolExecutionHandler;
        this.toolExecutionHandler = toolExecutionHandler;
        this.errorHandler = errorHandler;
        this.temporaryMemory = temporaryMemory;
        this.tokenUsage = (TokenUsage)ValidationUtils.ensureNotNull((Object)tokenUsage, (String)"tokenUsage");
        this.commonGuardrailParams = commonGuardrailParams;
        this.toolSpecifications = Utils.copy(toolSpecifications);
        this.toolExecutors = Utils.copy(toolExecutors);
        this.toolArgumentsErrorHandler = (ToolArgumentsErrorHandler)ValidationUtils.ensureNotNull((Object)toolArgumentsErrorHandler, (String)"toolArgumentsErrorHandler");
        this.toolExecutionErrorHandler = (ToolExecutionErrorHandler)ValidationUtils.ensureNotNull((Object)toolExecutionErrorHandler, (String)"toolExecutionErrorHandler");
        this.toolExecutor = toolExecutor;
        this.hasOutputGuardrails = context.guardrailService().hasOutputGuardrails(methodKey);
    }

    public void onPartialResponse(String partialResponse) {
        if (this.hasOutputGuardrails) {
            this.responseBuffer.add(partialResponse);
        } else {
            this.partialResponseHandler.accept(partialResponse);
        }
    }

    public void onPartialThinking(PartialThinking partialThinking) {
        if (this.partialThinkingHandler != null) {
            this.partialThinkingHandler.accept(partialThinking);
        }
    }

    public void onCompleteToolCall(CompleteToolCall completeToolCall) {
        if (this.toolExecutor != null) {
            CompletableFuture<ToolExecutionResultMessage> future = CompletableFuture.supplyAsync(() -> {
                ToolExecutionRequest toolExecutionRequest = completeToolCall.toolExecutionRequest();
                return this.execute(toolExecutionRequest);
            }, this.toolExecutor);
            this.toolResultFutures.add(future);
        }
    }

    public void onCompleteResponse(ChatResponse chatResponse) {
        AiMessage aiMessage = chatResponse.aiMessage();
        this.addToMemory((ChatMessage)aiMessage);
        if (aiMessage.hasToolExecutionRequests()) {
            if (this.intermediateResponseHandler != null) {
                this.intermediateResponseHandler.accept(chatResponse);
            }
            boolean immediateToolReturn = true;
            if (this.toolExecutor != null) {
                for (CompletableFuture completableFuture : this.toolResultFutures) {
                    try {
                        ToolExecutionResultMessage toolExecutionResultMessage = (ToolExecutionResultMessage)completableFuture.get();
                        this.addToMemory((ChatMessage)toolExecutionResultMessage);
                        immediateToolReturn = immediateToolReturn && this.context.toolService.isImmediateTool(toolExecutionResultMessage.toolName());
                    }
                    catch (ExecutionException e) {
                        Throwable throwable = e.getCause();
                        if (throwable instanceof RuntimeException) {
                            RuntimeException re = (RuntimeException)throwable;
                            throw re;
                        }
                        throw new RuntimeException(e.getCause());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
            } else {
                for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                    ToolExecutionResultMessage toolExecutionResultMessage = this.execute(toolExecutionRequest);
                    this.addToMemory((ChatMessage)toolExecutionResultMessage);
                    immediateToolReturn = immediateToolReturn && this.context.toolService.isImmediateTool(toolExecutionRequest.name());
                }
            }
            if (immediateToolReturn) {
                if (this.completeResponseHandler != null) {
                    ChatResponse finalChatResponse = this.finalResponse(chatResponse, aiMessage);
                    this.completeResponseHandler.accept(finalChatResponse);
                }
                return;
            }
            ChatRequest chatRequest = ChatRequest.builder().messages(this.messagesToSend(this.memoryId)).toolSpecifications(this.toolSpecifications).build();
            AiServiceStreamingResponseHandler aiServiceStreamingResponseHandler = new AiServiceStreamingResponseHandler(this.chatExecutor, this.context, this.memoryId, this.partialResponseHandler, this.partialThinkingHandler, this.beforeToolExecutionHandler, this.toolExecutionHandler, this.intermediateResponseHandler, this.completeResponseHandler, this.errorHandler, this.temporaryMemory, TokenUsage.sum((TokenUsage)this.tokenUsage, (TokenUsage)chatResponse.metadata().tokenUsage()), this.toolSpecifications, this.toolExecutors, this.toolArgumentsErrorHandler, this.toolExecutionErrorHandler, this.toolExecutor, this.commonGuardrailParams, this.methodKey);
            this.context.streamingChatModel.chat(chatRequest, (StreamingChatResponseHandler)aiServiceStreamingResponseHandler);
        } else if (this.completeResponseHandler != null) {
            ChatResponse finalChatResponse = this.finalResponse(chatResponse, aiMessage);
            if (this.hasOutputGuardrails) {
                if (this.commonGuardrailParams != null) {
                    GuardrailRequestParams newCommonParams = GuardrailRequestParams.builder().chatMemory(this.getMemory()).augmentationResult(this.commonGuardrailParams.augmentationResult()).userMessageTemplate(this.commonGuardrailParams.userMessageTemplate()).variables(this.commonGuardrailParams.variables()).build();
                    OutputGuardrailRequest outputGuardrailRequest = OutputGuardrailRequest.builder().responseFromLLM(finalChatResponse).chatExecutor(this.chatExecutor).requestParams(newCommonParams).build();
                    finalChatResponse = (ChatResponse)this.context.guardrailService().executeGuardrails(this.methodKey, outputGuardrailRequest);
                }
                this.responseBuffer.forEach(this.partialResponseHandler::accept);
                this.responseBuffer.clear();
            }
            this.completeResponseHandler.accept(finalChatResponse);
        }
    }

    private ChatResponse finalResponse(ChatResponse completeResponse, AiMessage aiMessage) {
        return ChatResponse.builder().aiMessage(aiMessage).metadata(completeResponse.metadata().toBuilder().tokenUsage(this.tokenUsage.add(completeResponse.metadata().tokenUsage())).build()).build();
    }

    private ToolExecutionResultMessage execute(ToolExecutionRequest toolRequest) {
        ToolExecutor toolExecutor = this.toolExecutors.get(toolRequest.name());
        this.handleBeforeTool(toolRequest);
        ToolExecutionResultMessage toolResult = ToolService.executeWithErrorHandling(toolRequest, toolExecutor, this.memoryId, this.toolArgumentsErrorHandler, this.toolExecutionErrorHandler);
        this.handleAfterTool(toolRequest, toolResult);
        return toolResult;
    }

    private void handleBeforeTool(ToolExecutionRequest toolExecutionRequest) {
        if (this.beforeToolExecutionHandler != null) {
            BeforeToolExecution beforeToolExecution = BeforeToolExecution.builder().request(toolExecutionRequest).build();
            this.beforeToolExecutionHandler.accept(beforeToolExecution);
        }
    }

    private void handleAfterTool(ToolExecutionRequest toolRequest, ToolExecutionResultMessage toolResult) {
        if (this.toolExecutionHandler != null) {
            ToolExecution toolExecution = ToolExecution.builder().request(toolRequest).result(toolResult.text()).build();
            this.toolExecutionHandler.accept(toolExecution);
        }
    }

    private ChatMemory getMemory() {
        return this.getMemory(this.memoryId);
    }

    private ChatMemory getMemory(Object memId) {
        return this.context.hasChatMemory() ? this.context.chatMemoryService.getOrCreateChatMemory(this.memoryId) : this.temporaryMemory;
    }

    private void addToMemory(ChatMessage chatMessage) {
        this.getMemory().add(chatMessage);
    }

    private List<ChatMessage> messagesToSend(Object memoryId) {
        return this.getMemory(memoryId).messages();
    }

    public void onError(Throwable error) {
        if (this.errorHandler != null) {
            try {
                this.errorHandler.accept(error);
            }
            catch (Exception e) {
                LOG.error("While handling the following error...", error);
                LOG.error("...the following error happened", (Throwable)e);
            }
        } else {
            LOG.warn("Ignored error", error);
        }
    }
}

